/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.SimilarityColorScheme;
import scri.commons.gui.RB;

public class LineSimilarityColorScheme
extends SimilarityColorScheme {
    public LineSimilarityColorScheme() {
    }

    public LineSimilarityColorScheme(GTView view, int w, int h) {
        super(view, w, h);
    }

    protected ColorState getState(int line, int marker) {
        int state = this.view.getState(line, marker);
        int comparisonIndex = this.view.getViewSet().getComparisonLineIndex();
        if (line == comparisonIndex) {
            return (ColorState)this.compStates.get(state);
        }
        if (comparisonIndex != -1) {
            int compState = this.view.getState(comparisonIndex, marker);
            switch (this.lookupTable[state][compState]) {
                case 1: {
                    return (ColorState)this.mtchStatesY.get(state);
                }
                case 2: {
                    return (ColorState)this.mtchStatesN.get(state);
                }
                case 3: {
                    return (ColorState)this.het1States.get(state);
                }
                case 4: {
                    return (ColorState)this.het2States.get(state);
                }
                case 5: {
                    return (ColorState)this.gsStates.get(state);
                }
            }
        }
        return (ColorState)this.gsStates.get(state);
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        return this.getState(line, marker).getColor();
    }

    @Override
    public int getModel() {
        return 2;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorLineSim");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.LineSimilarityColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMatchDark, RB.getString((String)"gui.visualization.colors.LineSimilarityColorScheme.state1Dark")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMatch, RB.getString((String)"gui.visualization.colors.LineSimilarityColorScheme.state1")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateNoMatch, RB.getString((String)"gui.visualization.colors.LineSimilarityColorScheme.state2")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMissing, RB.getString((String)"gui.visualization.colors.LineSimilarityColorScheme.state3")));
        return colors;
    }
}

