/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jhi.flapjack.data.Bookmark;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.WinMainMenuBar;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import scri.commons.gui.RB;

public class CanvasMenu {
    private GenotypeCanvas canvas;
    private WinMain winMain;
    private int menuShortcut;
    private JPopupMenu menu = new JPopupMenu();
    private JCheckBoxMenuItem mLock;
    private JMenuItem mBookmark;
    private JMenu mSplitLines;
    private JMenuItem mInsertLine;
    private JMenuItem mDeleteLine;
    private JMenuItem mInsertSplitter;
    private JMenuItem mRemoveSplitter;
    private JMenuItem mDuplicateLine;
    private JMenuItem mDuplicateLineRemove;
    private JCheckBoxMenuItem mShowGenotypes;
    private JMenu mHighlight;
    private JCheckBoxMenuItem mHighlightHtZ;
    private JCheckBoxMenuItem mHighlightHoZ;
    private JCheckBoxMenuItem mHighlightGaps;
    private JCheckBoxMenuItem mDisableGradients;
    private JMenuItem mSelectTraits;
    private JMenu mColor;
    private JMenuItem mColorCustomize;
    private JRadioButtonMenuItem mColorRandom;
    private JRadioButtonMenuItem mColorRandomWSP;
    private JRadioButtonMenuItem mColorNucleotide;
    private JRadioButtonMenuItem mColorNucleotide01;
    private JRadioButtonMenuItem mColorLineSim;
    private JRadioButtonMenuItem mColorLineSimExact;
    private JRadioButtonMenuItem mColorMarkerSim;
    private JRadioButtonMenuItem mColorSimple2Color;
    private JRadioButtonMenuItem mColorABHData;
    private JRadioButtonMenuItem mColorAlleleFreq;
    private JRadioButtonMenuItem mColorBinned;
    private JMenuItem mColorMagic;
    private JMenuItem mToggleCanvas;
    private JMenu mDataDB;
    private JMenuItem mDBLineName;
    private JMenuItem mDBMarkerName;
    private JMenuItem mDBSettings;
    private JMenu mSortLines;
    private JMenuItem mSortLinesBySimilarity;
    private JMenuItem mSortLinesByTrait;
    private JMenuItem mSortLinesByExternal;
    private JMenuItem mSortLinesAlphabetically;
    private JMenuItem mFind;
    private JMenu mFilter;
    private JMenuItem mFilterMissingMarkers;
    private JMenuItem mFilterMissingMarkersByLine;
    private JMenuItem mFilterHeterozygousMarkersByLine;
    private JMenuItem mFilterMonomorphicMarkers;

    CanvasMenu(GenotypeCanvas canvas, WinMain winMain) {
        this.canvas = canvas;
        this.winMain = winMain;
        this.menuShortcut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.createItems();
    }

    boolean isShowingMenu() {
        return this.menu.isVisible();
    }

    private void createItems() {
        this.mBookmark = WinMainMenuBar.getItem(Actions.viewBookmark, "gui.Actions.viewBookmark", 0, 0);
        this.mInsertLine = WinMainMenuBar.getItem(Actions.editInsertLine, "gui.Actions.editInsertLine", 0, 0);
        this.mDeleteLine = WinMainMenuBar.getItem(Actions.editDeleteLine, "gui.Actions.editDeleteLine", 0, 0);
        this.mDuplicateLine = WinMainMenuBar.getItem(Actions.editDuplicateLine, "gui.Actions.editDuplicateLine", 0, 0);
        this.mDuplicateLineRemove = WinMainMenuBar.getItem(Actions.editDuplicateLineRemove, "gui.Actions.editDuplicateLineRemove", 0, 0);
        this.mInsertSplitter = WinMainMenuBar.getItem(Actions.editInsertSplitter, "gui.Actions.editInsertLine", 0, 0);
        this.mRemoveSplitter = WinMainMenuBar.getItem(Actions.editDeleteSplitter, "gui.Actions.editDeleteLine", 0, 0);
        this.mShowGenotypes = WinMainMenuBar.getCheckedItem(Actions.vizOverlayGenotypes, "gui.Actions.vizOverlayGenotypes", 71, this.menuShortcut);
        this.mDisableGradients = WinMainMenuBar.getCheckedItem(Actions.vizDisableGradients, "gui.Actions.vizDisableGradients", 0, 0);
        this.mHighlightHtZ = WinMainMenuBar.getCheckedItem(Actions.vizHighlightHtZ, "gui.Actions.vizHighlightHtZ", 0, 0);
        this.mHighlightHoZ = WinMainMenuBar.getCheckedItem(Actions.vizHighlightHoZ, "gui.Actions.vizHighlightHoZ", 0, 0);
        this.mHighlightGaps = WinMainMenuBar.getCheckedItem(Actions.vizHighlightGaps, "gui.Actions.vizHighlightGaps", 0, 0);
        this.mSelectTraits = WinMainMenuBar.getItem(Actions.dataSelectTraits, "gui.Actions.dataSelectTraits", 0, 0);
        this.mColorCustomize = WinMainMenuBar.getItem(Actions.vizColorCustomize, "gui.Actions.vizColorCustomize", 0, 0);
        this.mColorRandom = WinMainMenuBar.getRadioItem(Actions.vizColorRandom, "gui.Actions.vizColorRandom", 0, 0);
        this.mColorRandomWSP = WinMainMenuBar.getRadioItem(Actions.vizColorRandomWSP, "gui.Actions.vizColorRandomWSP", 0, 0);
        this.mColorNucleotide = WinMainMenuBar.getRadioItem(Actions.vizColorNucleotide, "gui.Actions.vizColorNucleotide", 0, 0);
        this.mColorNucleotide01 = WinMainMenuBar.getRadioItem(Actions.vizColorNucleotide01, "gui.Actions.vizColorNucleotide01", 0, 0);
        this.mColorSimple2Color = WinMainMenuBar.getRadioItem(Actions.vizColorSimple2Color, "gui.Actions.vizColorSimple2Color", 0, 0);
        this.mColorABHData = WinMainMenuBar.getRadioItem(Actions.vizColorABHData, "gui.Actions.vizColorABHData", 0, 0);
        this.mColorLineSim = WinMainMenuBar.getRadioItem(Actions.vizColorLineSim, "gui.Actions.vizColorLineSim", 0, 0);
        this.mColorLineSimExact = WinMainMenuBar.getRadioItem(Actions.vizColorLineSimExact, "gui.Actions.vizColorLineSimExact", 0, 0);
        this.mColorMarkerSim = WinMainMenuBar.getRadioItem(Actions.vizColorMarkerSim, "gui.Actions.vizColorMarkerSim", 0, 0);
        this.mColorAlleleFreq = WinMainMenuBar.getRadioItem(Actions.vizColorAlleleFreq, "gui.Actions.vizColorAlleleFreq", 0, 0);
        this.mColorBinned = WinMainMenuBar.getRadioItem(Actions.vizColorBinned, "gui.Actions.vizColorBinned", 0, 0);
        this.mColorMagic = WinMainMenuBar.getRadioItem(Actions.vizColorMagic, "gui.Actions.vizColorMagic", 0, 0);
        this.mToggleCanvas = WinMainMenuBar.getItem(Actions.viewToggleCanvas, "gui.Actions.viewToggleCanvas", 0, 0);
        this.mFind = WinMainMenuBar.getItem(Actions.dataFind, "gui.Actions.dataFind", 70, this.menuShortcut);
        this.mDBLineName = WinMainMenuBar.getItem(Actions.dataDBLineName, "gui.Actions.dataDBLineName", 0, 0);
        this.mDBMarkerName = WinMainMenuBar.getItem(Actions.dataDBMarkerName, "gui.Actions.dataDBMarkerName", 0, 0);
        this.mDBSettings = WinMainMenuBar.getItem(Actions.dataDBSettings, "gui.Actions.dataDBSettings", 0, 0);
        this.mSplitLines = new JMenu(RB.getString((String)"gui.CanvasMenu.mSplitLines"));
        this.mSplitLines.add(this.mInsertLine);
        this.mSplitLines.add(this.mDeleteLine);
        this.mSplitLines.addSeparator();
        this.mSplitLines.add(this.mDuplicateLine);
        this.mSplitLines.add(this.mDuplicateLineRemove);
        this.mSplitLines.addSeparator();
        this.mSplitLines.add(this.mInsertSplitter);
        this.mSplitLines.add(this.mRemoveSplitter);
        this.mColor = new JMenu(RB.getString((String)"gui.WinMainMenuBar.mVizColor"));
        this.mColor.setIcon(Actions.getIcon("COLORS"));
        RB.setMnemonic((AbstractButton)this.mColor, (String)"gui.WinMainMenuBar.mVizColor");
        this.winMain.mViz.handleColorMenu(this.mColor);
        this.mColor.add(this.mColorNucleotide);
        this.mColor.add(this.mColorNucleotide01);
        this.mColor.add(this.mColorSimple2Color);
        this.mColor.add(this.mColorLineSim);
        this.mColor.add(this.mColorLineSimExact);
        this.mColor.add(this.mColorMarkerSim);
        this.mColor.add(this.mColorAlleleFreq);
        this.mColor.add(this.mColorMagic);
        this.mColor.add(this.mColorBinned);
        this.mColor.addSeparator();
        this.mColor.add(this.mColorRandom);
        this.mColor.add(this.mColorRandomWSP);
        this.mColor.addSeparator();
        this.mColor.add(this.mColorCustomize);
        this.mHighlight = new JMenu(RB.getString((String)"gui.WinMainMenuBar.mVizHighlight"));
        RB.setMnemonic((AbstractButton)this.mHighlight, (String)"gui.WinMainMenuBar.mVizHighlight");
        this.mHighlight.add(this.mHighlightHtZ);
        this.mHighlight.add(this.mHighlightHoZ);
        this.mHighlight.add(this.mHighlightGaps);
        this.mDataDB = new JMenu(RB.getString((String)"gui.WinMainMenuBar.mDataDB"));
        this.mDataDB.setIcon(Actions.getIcon("DATABASE"));
        RB.setMnemonic((AbstractButton)this.mDataDB, (String)"gui.WinMainMenuBar.mDataDB");
        this.mDataDB.add(this.mDBLineName);
        this.mDataDB.add(this.mDBMarkerName);
        this.mDataDB.addSeparator();
        this.mDataDB.add(this.mDBSettings);
        this.mSortLinesBySimilarity = WinMainMenuBar.getItem(Actions.alysSortLinesBySimilarity, "gui.Actions.alysSortLinesBySimilarity", 0, 0);
        this.mSortLinesByTrait = WinMainMenuBar.getItem(Actions.alysSortLinesByTrait, "gui.Actions.alysSortLinesByTrait", 0, 0);
        this.mSortLinesByExternal = WinMainMenuBar.getItem(Actions.alysSortLinesByExternal, "gui.Actions.alysSortLinesByExternal", 0, 0);
        this.mSortLinesAlphabetically = WinMainMenuBar.getItem(Actions.alysSortLinesAlphabetically, "gui.Actions.alysSortLinesAlphabetically", 0, 0);
        this.mSortLines = new JMenu(RB.getString((String)"gui.WinMainMenuBar.mAlysSortLines"));
        RB.setMnemonic((AbstractButton)this.mSortLines, (String)"gui.WinMainMenuBar.mAlysSortLines");
        this.mSortLines.add(this.mSortLinesAlphabetically);
        this.mSortLines.addSeparator();
        this.mSortLines.add(this.mSortLinesBySimilarity);
        this.mSortLines.add(this.mSortLinesByTrait);
        this.mSortLines.add(this.mSortLinesByExternal);
        this.mFilterMissingMarkers = WinMainMenuBar.getItem(Actions.editFilterMissingMarkers, "gui.Actions.editFilterMissingMarkers", 0, 0);
        this.mFilterMissingMarkersByLine = WinMainMenuBar.getItem(Actions.editFilterMissingMarkersByLine, "gui.Actions.editFilterMissingMarkersByLine", 0, 0);
        this.mFilterHeterozygousMarkersByLine = WinMainMenuBar.getItem(Actions.editFilterHeterozygousMarkersByLine, "gui.Actions.editFilterHeterozygousMarkersByLine", 0, 0);
        this.mFilterMonomorphicMarkers = WinMainMenuBar.getItem(Actions.editFilterMonomorphicMarkers, "gui.Actions.editFilterMonomorphicMarkers", 0, 0);
        this.mFilter = new JMenu(RB.getString((String)"gui.WinMainMenuBar.mEditFilterMarkers"));
        RB.setMnemonic((AbstractButton)this.mFilter, (String)"gui.WinMainMenuBar.mEditFilterMarkers");
        this.mFilter.add(this.mFilterMissingMarkers);
        this.mFilter.add(this.mFilterMissingMarkersByLine);
        this.mFilter.addSeparator();
        this.mFilter.add(this.mFilterHeterozygousMarkersByLine);
        this.mFilter.addSeparator();
        this.mFilter.add(this.mFilterMonomorphicMarkers);
    }

    void handlePopup(MouseEvent e) {
        int xIndex = this.canvas.getMarker(e.getPoint());
        int yIndex = this.canvas.getLine(e.getPoint());
        this.canvas.setHighlightedIndices(yIndex, xIndex);
        GTView view = this.canvas.view;
        this.menu = new JPopupMenu();
        this.menu.add(this.mBookmark);
        this.menu.addSeparator();
        this.menu.add(this.mSortLines);
        this.menu.add(this.mSplitLines);
        this.menu.add(this.mFilter);
        this.menu.addSeparator();
        this.menu.add(this.mColor);
        this.menu.add(this.mShowGenotypes);
        this.menu.add(this.mDisableGradients);
        this.menu.add(this.mHighlight);
        this.menu.addSeparator();
        this.menu.add(this.mSelectTraits);
        this.menu.addSeparator();
        this.menu.add(this.mFind);
        this.menu.add(this.mDataDB);
        this.mBookmark.setEnabled(Bookmark.allowBookmarking(view));
        this.mInsertSplitter.setEnabled(view.getSplitterIndex() == -1);
        if (view.getSplitterIndex() != -1) {
            this.mRemoveSplitter.setEnabled(true);
        } else {
            this.mRemoveSplitter.setEnabled(false);
        }
        this.mDeleteLine.setEnabled(view.hasDummyLines());
        this.mDuplicateLineRemove.setEnabled(false);
        if (view.mouseOverLine >= 0 && view.mouseOverLine < view.lineCount() && view.getLineInfo(view.mouseOverLine).getDuplicate()) {
            this.mDuplicateLineRemove.setEnabled(true);
        }
        if (view.getViewSet().tableHandler().table() != null || view.lineCount() == 0) {
            this.mInsertLine.setEnabled(false);
            this.mDuplicateLine.setEnabled(false);
            this.mInsertSplitter.setEnabled(false);
        }
        this.menu.show(e.getComponent(), e.getX(), e.getY());
    }
}

