/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.traits;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComboBox;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.gui.table.CellData;
import jhi.flapjack.gui.table.LineDataTableModel;
import scri.commons.gui.RB;

class TraitsTableModel
extends LineDataTableModel {
    private ArrayList<Trait> traits;

    TraitsTableModel(DataSet dataSet) {
        this.dataSet = dataSet;
        this.traits = dataSet.getTraits();
        this.setColumnNames();
    }

    void setColumnNames() {
        this.columnNames = new String[this.traits.size() + 1];
        this.columnNames[0] = RB.getString((String)"gui.traits.TraitsTableModel.line");
        for (int i = 1; i < this.columnNames.length; ++i) {
            this.columnNames[i] = this.traits.get(i - 1).getName();
            if (this.traits.get(i - 1).experimentDefined()) {
                int n = i;
                this.columnNames[n] = this.columnNames[n] + " (" + this.traits.get(i - 1).getExperiment() + ")";
            }
            if (this.traits.get(i - 1).traitIsNumerical()) {
                int n = i;
                this.columnNames[n] = this.columnNames[n] + " - numerical";
                continue;
            }
            int n = i;
            this.columnNames[n] = this.columnNames[n] + " - categorical";
        }
    }

    @Override
    public int getRowCount() {
        return this.dataSet.countLines();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return new CellData(null, this.getObjectAt(row, col));
    }

    @Override
    public Object getObjectAt(int row, int col) {
        if (col == 0) {
            return this.dataSet.getLineByIndex(row);
        }
        Line line = this.dataSet.getLineByIndex(row);
        TraitValue tv = line.getTraitValues().get(col - 1);
        return tv.tableValue();
    }

    @Override
    public Class getObjectColumnClass(int col) {
        if (col == 0) {
            return Line.class;
        }
        if (this.traits.get(col - 1).traitIsNumerical()) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.getObjectColumnClass(col) == String.class;
    }

    JComboBox getCategoryComboBox(int col) {
        JComboBox<String> combo = new JComboBox<String>();
        for (String category : this.traits.get(col - 1).getCategories()) {
            combo.addItem(category);
        }
        return combo;
    }

    @Override
    public Color getDisplayColor(int row, int col) {
        if (col > 0) {
            Line line = this.dataSet.getLineByIndex(row);
            Trait trait = this.traits.get(col - 1);
            TraitValue tv = line.getTraitValues().get(col - 1);
            if (tv.isDefined()) {
                return tv.displayColor();
            }
        }
        return null;
    }
}

