/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.table.FilterColumn;
import jhi.flapjack.gui.table.LineDataTable;
import scri.commons.gui.SimpleJob;

public class LineDataTableExporter
extends SimpleJob {
    private LineDataTable table;
    private File file;
    private int exportType;
    private boolean exportHeaders;
    private DecimalFormat df;

    public LineDataTableExporter(LineDataTable table, File file, int exportType, boolean exportHeaders) {
        this.table = table;
        this.file = file;
        this.exportType = exportType;
        this.exportHeaders = exportHeaders;
        this.df = new DecimalFormat("#.#########");
        if (exportType == 0) {
            LineDataTable clone = new LineDataTable();
            clone.setModel(table.getModel());
            clone.setColumnModel(table.getColumnModel());
            clone.getRowSorter().setSortKeys(table.getRowSorter().getSortKeys());
            this.table = clone;
        }
    }

    public void runJob(int i) throws Exception {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
        if (this.exportHeaders) {
            this.printInfoHeaders(out);
        }
        StringBuilder headerBuilder = new StringBuilder();
        for (int col = 0; col < this.table.getColumnCount(); ++col) {
            if (this.table.skipExport(col)) continue;
            if (headerBuilder.length() > 0) {
                headerBuilder.append("\t");
            }
            headerBuilder.append(this.table.getColumnName(col));
        }
        out.println(headerBuilder.toString());
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            int col0 = this.table.convertColumnIndexToView(0);
            LineInfo line = (LineInfo)this.table.getObjectAt(row, col0);
            if (this.exportType == 2 && !line.getSelected()) continue;
            StringBuilder builder = new StringBuilder();
            for (int col = 0; col < this.table.getColumnCount(); ++col) {
                Object obj;
                if (this.table.skipExport(col)) continue;
                if (builder.length() > 0) {
                    builder.append("\t");
                }
                if ((obj = this.table.getObjectAt(row, col)) instanceof Float || obj instanceof Double) {
                    builder.append(this.getNumberString(obj));
                    continue;
                }
                builder.append(obj);
            }
            out.println(builder.toString());
        }
        out.close();
    }

    private void printInfoHeaders(PrintWriter out) throws Exception {
        List<RowSorter.SortKey> sortKeys;
        if (this.table.getTableFilter() != null) {
            for (FilterColumn col : this.table.getTableFilter()) {
                if (col.disabled()) continue;
                out.println("# FILTER\t" + col.name + "\t" + col.toShortString() + (col.getValue() != null ? "\t" + col.getValue() : ""));
            }
        }
        if ((sortKeys = this.table.getRowSorter().getSortKeys()).size() > 0) {
            for (int i = 0; i < sortKeys.size(); ++i) {
                int col = sortKeys.get(i).getColumn();
                SortOrder ord = sortKeys.get(i).getSortOrder();
                out.println("# SORT " + i + "\t" + this.table.getModel().getColumnName(col) + "\t" + (Object)((Object)ord));
            }
        }
    }

    private String getNumberString(Object value) {
        if (value instanceof Double && (Double.isNaN((Double)value) || Double.isInfinite((Double)value))) {
            return value.toString();
        }
        if (value instanceof Float && (Float.isNaN(((Float)value).floatValue()) || Float.isInfinite(((Float)value).floatValue()))) {
            return value.toString();
        }
        return this.df.format(value);
    }
}

