/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.dialog.importer.BrapiDataPanelNB;
import jhi.flapjack.gui.dialog.importer.BrapiMapsPanelNB;
import jhi.flapjack.gui.dialog.importer.BrapiPassPanelNB;
import jhi.flapjack.gui.dialog.importer.BrapiStudiesPanelNB;
import jhi.flapjack.gui.dialog.importer.IBrapiWizard;
import jhi.flapjack.io.brapi.BrapiClient;
import scri.commons.gui.RB;
import scri.commons.gui.SwingUtils;
import scri.commons.gui.matisse.DialogPanel;

public class BrapiImportDialog
extends JDialog
implements ActionListener {
    private JButton bNext;
    private JButton bBack;
    private JButton bCancel;
    private JButton bHelp;
    private boolean isOK = false;
    private IBrapiWizard dataPanel;
    private IBrapiWizard passPanel;
    private IBrapiWizard mapsPanel;
    private IBrapiWizard studiesPanel;
    private IBrapiWizard currentPanel;
    private CardLayout cards = new CardLayout();
    private JPanel panel = new JPanel();
    private BrapiClient client = new BrapiClient();

    public BrapiImportDialog() {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.importer.BrapiImportDialog.title"), true);
        this.dataPanel = new BrapiDataPanelNB(this.client, this);
        this.passPanel = new BrapiPassPanelNB(this.client, this);
        this.mapsPanel = new BrapiMapsPanelNB(this.client, this);
        this.studiesPanel = new BrapiStudiesPanelNB(this.client, this);
        this.panel.setLayout(this.cards);
        this.panel.add((Component)this.dataPanel.getPanel(), this.dataPanel.getCardName());
        this.panel.add((Component)this.passPanel.getPanel(), this.passPanel.getCardName());
        this.panel.add((Component)this.mapsPanel.getPanel(), this.mapsPanel.getCardName());
        this.panel.add((Component)this.studiesPanel.getPanel(), this.studiesPanel.getCardName());
        this.add(this.panel);
        this.add((Component)this.createButtons(), "South");
        this.getRootPane().setDefaultButton(this.bNext);
        SwingUtils.addCloseHandler((Window)this, (JComponent)this.bCancel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                BrapiImportDialog.this.setScreen(BrapiImportDialog.this.dataPanel);
            }
        });
        this.pack();
        this.setLocationRelativeTo(Flapjack.winMain);
        this.setResizable(false);
        this.setVisible(true);
    }

    private JPanel createButtons() {
        this.bNext = new JButton("Next >");
        this.bNext.setEnabled(false);
        this.bNext.addActionListener(this);
        this.bBack = new JButton("< Back");
        this.bBack.setEnabled(false);
        this.bBack.addActionListener(this);
        this.bCancel = new JButton(RB.getString((String)"gui.text.cancel"));
        this.bCancel.addActionListener(this);
        this.bHelp = new JButton(RB.getString((String)"gui.text.help"));
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "_-_Import_Data");
        DialogPanel p1 = new DialogPanel();
        p1.add(this.bBack);
        p1.add(this.bNext);
        p1.add(this.bCancel);
        p1.add(this.bHelp);
        return p1;
    }

    void enableNext(boolean enabled) {
        this.bNext.setEnabled(enabled);
    }

    void enableBack(boolean enabled) {
        this.bBack.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bNext) {
            this.currentPanel.onNext();
        } else if (e.getSource() == this.bBack) {
            this.currentPanel.onBack();
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    void setScreen(IBrapiWizard screen) {
        this.cards.show(this.panel, screen.getCardName());
        screen.onShow();
        this.currentPanel = screen;
    }

    void wizardCompleted() {
        this.isOK = true;
        this.setVisible(false);
    }

    public boolean isOK() {
        return this.isOK;
    }

    public BrapiClient getBrapiClient() {
        return this.client;
    }

    IBrapiWizard getDataPanel() {
        return this.dataPanel;
    }

    IBrapiWizard getPassPanel() {
        return this.passPanel;
    }

    IBrapiWizard getMapsPanel() {
        return this.mapsPanel;
    }

    IBrapiWizard getStudiesPanel() {
        return this.studiesPanel;
    }

    public JButton getBNext() {
        return this.bNext;
    }

    public JButton getBBack() {
        return this.bBack;
    }
}

