/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import jhi.flapjack.data.XMLRoot;

public class Marker
extends XMLRoot
implements Comparable<Marker> {
    private String name;
    private double position;
    private double realPosition;
    private float[] frequencies;
    private static String[] alleles;

    public Marker() {
    }

    public Marker(String name, double position) {
        this.name = new String(name);
        this.position = position;
        this.realPosition = position;
    }

    public Marker(String name, double position, double realPosition) {
        this.name = new String(name);
        this.position = position;
        this.realPosition = realPosition;
    }

    public Marker(boolean dummy, double position) {
        this.name = "DUMMYMARKER";
        this.position = position;
        this.realPosition = -1000.0;
    }

    void validate() throws NullPointerException {
        if (this.name == null) {
            throw new NullPointerException();
        }
        if (this.realPosition < 0.0 && this.realPosition != -1000.0) {
            this.realPosition = this.position;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    public double getRealPosition() {
        return this.realPosition;
    }

    public void setRealPosition(double realPosition) {
        this.realPosition = realPosition;
    }

    public String toString() {
        return this.name;
    }

    public float[] frequencies() {
        return this.frequencies;
    }

    public void setFrequencies(float[] frequencies) {
        this.frequencies = frequencies;
    }

    public static String[] alleles() {
        return alleles;
    }

    public static void setAlleles(String[] array) {
        alleles = array;
    }

    @Override
    public int compareTo(Marker marker) {
        if (marker.position > this.position) {
            return -1;
        }
        if (marker.position == this.position) {
            return 0;
        }
        return 1;
    }

    public boolean dummyMarker() {
        return this.realPosition == -1000.0;
    }
}

