/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.QTL;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.HyperLinkLabel;

class FilterQTLsPanelNB
extends JPanel
implements ActionListener {
    private GenotypePanel gPanel;
    private DataSet dataSet;
    private LinkedHashMap<String, Boolean> traits;
    private LinkedHashMap<String, Boolean> experiments;
    private JLabel experimentsLabel;
    private JTable experimentsTable;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel label2;
    private JLabel label3;
    private JLabel numberLabel;
    private JPanel panel;
    private HyperLinkLabel selectAllExperiments;
    private HyperLinkLabel selectAllTraits;
    private HyperLinkLabel selectNoExperiments;
    private HyperLinkLabel selectNoTraits;
    private JLabel traitsLabel;
    private JTable traitsTable;

    public FilterQTLsPanelNB(GenotypePanel gPanel, DataSet dataSet) {
        this.gPanel = gPanel;
        this.initComponents();
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        this.panel.setBackground((Color)UIManager.get("fjDialogBG"));
        this.panel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBFilterQTLsPanel.panel.title")));
        RB.setText((JLabel)this.traitsLabel, (String)"gui.dialog.NBFilterQTLsPanel.traitsLabel");
        RB.setText((JLabel)this.experimentsLabel, (String)"gui.dialog.NBFilterQTLsPanel.experimentsLabel");
        RB.setText((JLabel)this.selectAllTraits, (String)"gui.dialog.NBFilterQTLsPanel.selectAll");
        RB.setText((JLabel)this.selectNoTraits, (String)"gui.dialog.NBFilterQTLsPanel.selectNone");
        RB.setText((JLabel)this.selectAllExperiments, (String)"gui.dialog.NBFilterQTLsPanel.selectAll");
        RB.setText((JLabel)this.selectNoExperiments, (String)"gui.dialog.NBFilterQTLsPanel.selectNone");
        this.dataSet = dataSet;
        this.updateTables();
        this.createLinkLabels();
    }

    private void updateTables() {
        this.initHashtables();
        this.createTraitsTable();
        this.createExperimentsTable();
    }

    private void initHashtables() {
        this.traits = new LinkedHashMap();
        this.experiments = new LinkedHashMap();
        int count = 0;
        for (ChromosomeMap cMap : this.dataSet.getChromosomeMaps()) {
            for (QTL qtl : cMap.getQtls()) {
                count += qtl.isVisible() ? 1 : 0;
                Boolean tValue = this.traits.get(qtl.getTrait());
                if (tValue == null) {
                    this.traits.put(qtl.getTrait(), qtl.isVisible());
                } else if (qtl.isVisible()) {
                    this.traits.put(qtl.getTrait(), true);
                }
                Boolean eValue = this.experiments.get(qtl.getExperiment());
                if (eValue == null) {
                    this.experiments.put(qtl.getExperiment(), qtl.isVisible());
                    continue;
                }
                if (!qtl.isVisible()) continue;
                this.experiments.put(qtl.getExperiment(), true);
            }
        }
        this.numberLabel.setText(RB.format((String)"gui.dialog.NBFilterQTLsPanel.numberLabel", (Object[])new Object[]{count}));
    }

    private void createTraitsTable() {
        String[] columnNames = new String[]{RB.getString((String)"gui.dialog.NBFilterQTLsPanel.trait"), ""};
        Object[][] data = new Object[this.traits.size()][2];
        Iterator<String> itor = this.traits.keySet().iterator();
        int i = 0;
        while (itor.hasNext()) {
            data[i][0] = itor.next();
            data[i][1] = this.traits.get(data[i][0]);
            ++i;
        }
        this.traitsTable.setModel(this.getModel(data, columnNames));
        this.traitsTable.getColumnModel().getColumn(1).setMaxWidth(35);
    }

    private void createExperimentsTable() {
        String[] columnNames = new String[]{RB.getString((String)"gui.dialog.NBFilterQTLsPanel.experiment"), ""};
        Object[][] data = new Object[this.experiments.size()][2];
        Iterator<String> itor = this.experiments.keySet().iterator();
        int i = 0;
        while (itor.hasNext()) {
            data[i][0] = itor.next();
            data[i][1] = this.experiments.get(data[i][0]);
            ++i;
        }
        this.experimentsTable.setModel(this.getModel(data, columnNames));
        this.experimentsTable.getColumnModel().getColumn(1).setMaxWidth(35);
    }

    private DefaultTableModel getModel(Object[][] data, String[] columnNames) {
        return new DefaultTableModel(data, columnNames){

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }
        };
    }

    private void createLinkLabels() {
        this.selectAllTraits.addActionListener((ActionListener)this);
        this.selectNoTraits.addActionListener((ActionListener)this);
        this.selectAllExperiments.addActionListener((ActionListener)this);
        this.selectNoExperiments.addActionListener((ActionListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.selectAllTraits) {
            this.tableSelect(this.traitsTable, true);
        } else if (event.getSource() == this.selectNoTraits) {
            this.tableSelect(this.traitsTable, false);
        } else if (event.getSource() == this.selectAllExperiments) {
            this.tableSelect(this.experimentsTable, true);
        } else if (event.getSource() == this.selectNoExperiments) {
            this.tableSelect(this.experimentsTable, false);
        }
    }

    void tableSelect(JTable table, boolean state) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setValueAt(state, i, 1);
        }
    }

    void filterQTLs() {
        int i;
        this.traits.clear();
        this.experiments.clear();
        for (i = 0; i < this.traitsTable.getRowCount(); ++i) {
            String tName = (String)this.traitsTable.getValueAt(i, 0);
            boolean tValue = (Boolean)this.traitsTable.getValueAt(i, 1);
            this.traits.put(tName, tValue);
        }
        for (i = 0; i < this.experimentsTable.getRowCount(); ++i) {
            String eName = (String)this.experimentsTable.getValueAt(i, 0);
            boolean eValue = (Boolean)this.experimentsTable.getValueAt(i, 1);
            this.experiments.put(eName, eValue);
        }
        for (ChromosomeMap cMap : this.dataSet.getChromosomeMaps()) {
            for (QTL qtl : cMap.getQtls()) {
                if (!qtl.isAllowed()) continue;
                if (this.traits.get(qtl.getTrait()).booleanValue() && this.experiments.get(qtl.getExperiment()).booleanValue()) {
                    qtl.setVisible(true);
                    continue;
                }
                qtl.setVisible(false);
            }
        }
        Flapjack.winMain.repaint();
        this.gPanel.refreshView();
        this.updateTables();
        Actions.projectModified();
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.traitsTable = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.experimentsTable = new JTable();
        this.traitsLabel = new JLabel();
        this.experimentsLabel = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.numberLabel = new JLabel();
        this.selectAllTraits = new HyperLinkLabel();
        this.selectNoTraits = new HyperLinkLabel();
        this.selectAllExperiments = new HyperLinkLabel();
        this.selectNoExperiments = new HyperLinkLabel();
        this.panel.setBorder(BorderFactory.createTitledBorder("Filter visible QTLs:"));
        this.traitsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.traitsTable.setRowSelectionAllowed(false);
        this.traitsTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.traitsTable);
        this.experimentsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.experimentsTable.setRowSelectionAllowed(false);
        this.experimentsTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.experimentsTable);
        this.traitsLabel.setLabelFor(this.traitsTable);
        this.traitsLabel.setText("Only show these traits:");
        this.experimentsLabel.setLabelFor(this.experimentsTable);
        this.experimentsLabel.setText("Only show these experiments:");
        this.label2.setText("|");
        this.label3.setText("|");
        this.numberLabel.setText("Number of QTLs currently visible (across all chromosomes):");
        this.selectAllTraits.setText("Select all");
        this.selectNoTraits.setText("Select none");
        this.selectAllExperiments.setText("Select all");
        this.selectNoExperiments.setText("Select none");
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.traitsLabel).addGroup(panelLayout.createSequentialGroup().addComponent((Component)this.selectAllTraits, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selectNoTraits, -2, -1, -2)).addComponent(this.jScrollPane1, -2, 198, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addComponent((Component)this.selectAllExperiments, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selectNoExperiments, -2, -1, -2)).addComponent(this.experimentsLabel).addComponent(this.jScrollPane2, -2, 192, -2))).addComponent(this.numberLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        panelLayout.linkSize(0, this.jScrollPane1, this.jScrollPane2);
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addComponent(this.traitsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent((Component)this.selectAllTraits, -2, -1, -2).addComponent((Component)this.selectNoTraits, -2, -1, -2))).addGroup(panelLayout.createSequentialGroup().addComponent(this.experimentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label3).addComponent((Component)this.selectAllExperiments, -2, -1, -2).addComponent((Component)this.selectNoExperiments, -2, -1, -2)))).addGap(18, 18, 18).addComponent(this.numberLabel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

