/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.data.QTLInfo;

public class AnalysisSet {
    private DataSet dataSet;
    private GTViewSet viewSet;
    private ArrayList<LineInfo> lines;
    private ArrayList<ViewInfo> views;

    public AnalysisSet(GTViewSet viewSet) {
        this.viewSet = viewSet;
        this.dataSet = viewSet.getDataSet();
    }

    public AnalysisSet withViews(boolean[] selectedChromosomes) {
        this.views = new ArrayList();
        for (int i = 0; i < this.viewSet.getViews().size(); ++i) {
            if (selectedChromosomes != null && !selectedChromosomes[i]) continue;
            this.views.add(new ViewInfo(this.viewSet.getView(i)));
        }
        return this;
    }

    public AnalysisSet withAllLines() {
        this.lines = this.viewSet.getLines().stream().filter(li -> !li.getDuplicate()).filter(li -> li.getLine() != this.dataSet.getDummyLine()).filter(li -> li.getLine() != this.dataSet.getSplitter()).collect(Collectors.toCollection(ArrayList::new));
        return this;
    }

    public AnalysisSet withSelectedLines() {
        this.withAllLines();
        this.lines = this.lines.stream().filter(li -> li.getSelected()).collect(Collectors.toCollection(ArrayList::new));
        return this;
    }

    public AnalysisSet withAllMarkers() {
        for (ViewInfo vInfo : this.views) {
            ArrayList<MarkerInfo> allMarkers = vInfo.view.getMarkers();
            vInfo.markers = allMarkers.stream().filter(mi -> !mi.dummyMarker()).sorted().collect(Collectors.toCollection(ArrayList::new));
        }
        return this;
    }

    public AnalysisSet withAllMarkersIncludingHidden() {
        this.withAllMarkers();
        for (ViewInfo vInfo : this.views) {
            ArrayList<MarkerInfo> hiddenMarkers = vInfo.view.getHideMarkers();
            vInfo.markers.addAll(hiddenMarkers.stream().filter(mi -> !mi.dummyMarker()).collect(Collectors.toCollection(ArrayList::new)));
            Collections.sort(vInfo.markers);
        }
        return this;
    }

    public AnalysisSet withSelectedMarkers() {
        this.withAllMarkers();
        for (ViewInfo vInfo : this.views) {
            vInfo.markers = vInfo.markers.stream().filter(mi -> mi.getSelected()).collect(Collectors.toCollection(ArrayList::new));
        }
        return this;
    }

    public ArrayList<LineInfo> getLines() {
        return this.lines;
    }

    public int getState(int view, int line, int marker) {
        return this.views.get(view).getState(line, marker);
    }

    public GTView getGTView(int view) {
        return this.views.get(view).getGTView();
    }

    public double mapLength(int view) {
        return this.views.get(view).mapLength();
    }

    public ArrayList<QTLInfo> qtls(int view) {
        return this.views.get(view).qtls();
    }

    public int viewCount() {
        return this.views.size();
    }

    public int lineCount() {
        return this.lines.size();
    }

    public int markerCount(int view) {
        return this.views.get(view).markers.size();
    }

    public LineInfo getLine(int lineIndex) {
        return this.lines.get(lineIndex);
    }

    public MarkerInfo getMarker(int view, int markerIndex) {
        return (MarkerInfo)this.views.get(view).markers.get(markerIndex);
    }

    public ArrayList<MarkerInfo> getMarkers(int view) {
        return this.views.get(view).markers;
    }

    public long countAlleles() {
        long totalMarkers = 0L;
        for (ViewInfo view : this.views) {
            totalMarkers += (long)view.markers.size();
        }
        return totalMarkers * (long)this.lines.size();
    }

    private class ViewInfo {
        private ArrayList<MarkerInfo> markers;
        private int chrMapIndex;
        private GTView view;

        ViewInfo(GTView view) {
            this.view = view;
            this.chrMapIndex = AnalysisSet.this.viewSet.getDataSet().getChromosomeMaps().indexOf(view.getChromosomeMap());
        }

        public int getState(int lineIndex, int markerIndex) {
            int mrkIndex = this.markers.get(markerIndex).getIndex();
            return ((LineInfo)AnalysisSet.this.lines.get(lineIndex)).getState(this.chrMapIndex, mrkIndex);
        }

        GTView getGTView() {
            return this.view;
        }

        double mapLength() {
            return this.view.getChromosomeMap().getLength();
        }

        ArrayList<QTLInfo> qtls() {
            return this.view.getQTLs();
        }
    }
}

