/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Project;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.ChromosomeMapImporter;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.GenotypeDataImporter;
import jhi.flapjack.io.PostImportOperations;
import jhi.flapjack.io.ProjectSerializer;
import jhi.flapjack.io.ProjectSerializerDB;
import jhi.flapjack.io.QTLImporter;
import jhi.flapjack.io.TraitImporter;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class CreateProject {
    private Project project = new Project();
    private DataSet dataSet = new DataSet();
    private File mapFile;
    private File genotypesFile;
    private File traitsFile;
    private File qtlsFile;
    private FlapjackFile prjFile;
    private boolean decimalEnglish = false;
    private List<String> output = new ArrayList<String>();

    public static void main(String[] args) {
        CreateProject cProj = new CreateProject(args);
        cProj.doProjectCreation();
        System.exit(0);
    }

    private CreateProject(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-map=")) {
                this.mapFile = new File(arg.substring(5));
            }
            if (arg.startsWith("-genotypes=")) {
                this.genotypesFile = new File(arg.substring(11));
            }
            if (arg.startsWith("-traits=")) {
                this.traitsFile = new File(arg.substring(8));
            }
            if (arg.startsWith("-qtls=")) {
                this.qtlsFile = new File(arg.substring(6));
            }
            if (arg.startsWith("-project=")) {
                this.prjFile = new FlapjackFile(arg.substring(9));
            }
            if (!arg.startsWith("-decimalEnglish")) continue;
            this.decimalEnglish = true;
        }
        if (this.genotypesFile == null || this.prjFile == null) {
            this.printHelp();
        }
    }

    public CreateProject(File mapFile, File genotypesFile, File traitsFile, File qtlsFile, FlapjackFile prjFile, boolean decimalEnglish) {
        this.mapFile = mapFile;
        this.genotypesFile = genotypesFile;
        this.traitsFile = traitsFile;
        this.qtlsFile = qtlsFile;
        this.decimalEnglish = decimalEnglish;
        this.prjFile = prjFile;
    }

    public List<String> doProjectCreation() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        FlapjackUtils.initialiseSqlite();
        if (this.decimalEnglish) {
            Locale.setDefault(Locale.UK);
        }
        try {
            this.openProject();
            this.createProject();
            this.importTraits();
            this.importQTLs();
            if (this.prjFile != null && this.saveProject()) {
                this.logMessage("\nProject Created");
            }
            ProjectSerializerDB.close();
        }
        catch (Exception e) {
            this.logMessage(e.toString());
            System.exit(1);
        }
        return this.output;
    }

    private void createProject() throws Exception {
        ChromosomeMapImporter mapImporter = new ChromosomeMapImporter(this.mapFile, this.dataSet);
        mapImporter.importMap();
        GenotypeDataImporter genoImporter = new GenotypeDataImporter(this.genotypesFile, this.dataSet, mapImporter.getMarkersHashMap(), "-", true, "/", false);
        genoImporter.importGenotypeData();
        PostImportOperations pio = new PostImportOperations(this.dataSet);
        pio.collapseHomzEncodedAsHet();
        pio.optimizeStateTable();
        pio.createDefaultView();
        if (this.prjFile != null) {
            pio.setName(this.prjFile.getFile());
        }
        this.project.addDataSet(this.dataSet);
    }

    private void importTraits() throws Exception {
        if (this.traitsFile == null) {
            return;
        }
        this.logMessage("Importing traits from " + this.traitsFile);
        TraitImporter importer = new TraitImporter(this.traitsFile, this.dataSet);
        importer.runJob(0);
        this.dataSet.getViewSets().get(0).assignTraits();
    }

    private void importQTLs() throws Exception {
        if (this.qtlsFile == null) {
            return;
        }
        this.logMessage("Importing QTLs from " + this.qtlsFile);
        QTLImporter importer = new QTLImporter(this.qtlsFile, this.dataSet);
        importer.runJob(0);
    }

    private void openProject() throws Exception {
        if (this.prjFile != null && this.prjFile.exists() && this.prjFile.getFile().length() > 0L) {
            this.project = ProjectSerializer.open(this.prjFile);
        }
    }

    private boolean saveProject() throws Exception {
        this.project.fjFile = this.prjFile;
        return ProjectSerializer.save(this.project);
    }

    private void logMessage(String message) {
        System.out.println(message);
        this.output.add(message);
    }

    DataSet dataSet() {
        return this.dataSet;
    }

    private void printHelp() {
        System.out.println("Usage: createproject <options>\n where valid options are:\n   -map=<map_file>                (optional input file)\n   -genotypes=<genotypes_file>    (required input file)\n   -traits=<traits_file>          (optional input file)\n   -qtls=<qtl_file>               (optional input file)\n   -decimalEnglish                (optional input parameter)\n   -project=<project_file>        (required output file)\n");
        System.exit(1);
    }
}

