/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.brapi;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jhi.brapi.api.markerprofiles.BrapiAlleleMatrix;
import jhi.brapi.api.markerprofiles.BrapiMarkerProfile;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.io.IGenotypeImporter;
import jhi.flapjack.io.MarkerIndex;
import jhi.flapjack.io.brapi.BrapiClient;

public class BrapiGenotypeImporter
implements IGenotypeImporter {
    private DataSet dataSet;
    private StateTable stateTable;
    private HashMap<String, MarkerIndex> markers;
    private HashMap<String, MarkerIndex> markersByName;
    private HashMap<String, Integer> states = new HashMap();
    private String ioMissingData;
    private boolean ioUseHetSep;
    private String ioHeteroSeparator;
    private long alleleCount;
    private boolean useByteStorage = true;
    private boolean isOK = true;
    private BrapiClient client;

    public BrapiGenotypeImporter(BrapiClient client, DataSet dataSet, HashMap<String, MarkerIndex> markers, HashMap<String, MarkerIndex> markersByName, String ioMissingData, boolean ioUseHetSep, String ioHeteroSeparator) {
        this.client = client;
        this.dataSet = dataSet;
        this.markers = markers;
        this.markersByName = markersByName;
        this.ioMissingData = ioMissingData;
        this.ioUseHetSep = ioUseHetSep;
        this.ioHeteroSeparator = ioHeteroSeparator;
        this.ioMissingData = "N";
        this.ioUseHetSep = true;
        this.ioHeteroSeparator = "/";
        this.stateTable = dataSet.getStateTable();
    }

    @Override
    public void cleanUp() {
        this.markers.clear();
    }

    @Override
    public void cancelImport() {
        this.isOK = false;
    }

    @Override
    public long getLineCount() {
        return this.dataSet.getLines().size();
    }

    @Override
    public long getMarkerCount() {
        return this.alleleCount;
    }

    @Override
    public void importGenotypeData() throws Exception {
        if (!this.readData()) {
            this.dataSet.getLines().clear();
            this.stateTable.resetTable();
            this.states.clear();
            this.useByteStorage = false;
            this.alleleCount = 0L;
            this.readData();
        }
    }

    private boolean readData() throws Exception {
        List<BrapiMarkerProfile> profiles = this.client.getMarkerProfiles();
        HashMap<String, Line> linesByProfileID = new HashMap<String, Line>();
        HashMap<String, Line> linesByName = new HashMap<String, Line>();
        for (BrapiMarkerProfile mp : profiles) {
            String name = mp.getUniqueDisplayName();
            Line line = this.dataSet.createLine(name, this.useByteStorage);
            linesByProfileID.put(mp.getMarkerProfileDbId(), line);
            linesByName.put(name, line);
        }
        if (this.client.hasAlleleMatrixSearchTSV()) {
            return this.readTSVAlleleMatrix(linesByProfileID, profiles);
        }
        if (this.client.hasAlleleMatrixSearchFlapjack()) {
            return this.readFlapjackAlleleMatrix(linesByName, profiles);
        }
        return this.readJSONAlleleMatrix(linesByProfileID, profiles);
    }

    @Override
    public long getBytesRead() {
        return 0L;
    }

    private boolean readTSVAlleleMatrix(HashMap<String, Line> linesByProfileID, List<BrapiMarkerProfile> profiles) throws Exception {
        URI uri = this.client.getAlleleMatrixTSV(profiles);
        URLConnection urlConnection = this.client.addAuthTokenToConnection(uri.toURL().openConnection());
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        String str = in.readLine();
        String[] tmpstr = str.split("\t");
        List<String> markerprofileIds = Arrays.asList(tmpstr);
        while ((str = in.readLine()) != null && !str.isEmpty()) {
            String mpID;
            Line line;
            String[] tokens = str.split("\t");
            String markerID = tokens[0];
            MarkerIndex index = this.markers.get(markerID);
            for (int j = 1; j < tokens.length && (line = linesByProfileID.get(mpID = markerprofileIds.get(j))) != null && index != null; ++j) {
                String allele = tokens[j];
                Integer stateCode = this.states.computeIfAbsent(allele, a -> this.stateTable.getStateCode((String)a, true, this.ioMissingData, this.ioUseHetSep, this.ioHeteroSeparator));
                line.setLoci(index.mapIndex, index.mkrIndex, stateCode);
                ++this.alleleCount;
            }
            if (this.useByteStorage && this.stateTable.size() > 127) {
                return false;
            }
            if (this.isOK) continue;
            break;
        }
        in.close();
        return true;
    }

    private boolean readFlapjackAlleleMatrix(HashMap<String, Line> linesByName, List<BrapiMarkerProfile> profiles) throws Exception {
        String str;
        System.out.println("Reading Flapjack Genotype File");
        linesByName.keySet().forEach(key -> System.out.println(key + " : " + linesByName.get(key)));
        URI uri = this.client.getAlleleMatrixFlapjack(profiles);
        BufferedReader in = new BufferedReader(new InputStreamReader(uri.toURL().openStream()));
        while ((str = in.readLine()) != null && !str.isEmpty()) {
            System.out.println(str);
            if (str.startsWith("#")) continue;
            String[] markerNames = str.split("\t");
            int[] mapIndex = new int[markerNames.length];
            int[] mkrIndex = new int[markerNames.length];
            for (int i = 1; i < markerNames.length && this.isOK; ++i) {
                MarkerIndex index = this.markersByName.get(markerNames[i].trim());
                if (index != null) {
                    mapIndex[i] = index.mapIndex;
                    mkrIndex[i] = index.mkrIndex;
                    continue;
                }
                mkrIndex[i] = -1;
                mapIndex[i] = -1;
            }
            System.out.println("Read header");
            while ((str = in.readLine()) != null && this.isOK) {
                String name;
                Line line;
                String[] values;
                if (str.length() == 0 || (values = str.trim().split("\t")).length == 0 || (line = linesByName.get(name = values[0].trim())) == null) continue;
                for (int i = 1; i < values.length; ++i) {
                    if (mapIndex[i] == -1) continue;
                    Integer stateCode = this.states.computeIfAbsent(values[i], a -> this.stateTable.getStateCode((String)a, true, this.ioMissingData, this.ioUseHetSep, this.ioHeteroSeparator));
                    line.setLoci(mapIndex[i], mkrIndex[i], stateCode);
                }
                if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
                return false;
            }
        }
        in.close();
        return true;
    }

    private boolean readJSONAlleleMatrix(HashMap<String, Line> linesByProfileID, List<BrapiMarkerProfile> profiles) throws Exception {
        List<BrapiAlleleMatrix> matrixList = this.client.getAlleleMatrix(profiles);
        for (int m = 0; m < matrixList.size(); ++m) {
            BrapiAlleleMatrix matrix = matrixList.get(m);
            for (int call = 0; call < matrix.getData().size(); ++call) {
                String markerDbId = matrix.markerId(call);
                String markerprofileDbId = matrix.markerProfileId(call);
                String allele = matrix.allele(call);
                Line line = linesByProfileID.get(markerprofileDbId);
                MarkerIndex index = this.markers.get(markerDbId);
                if (line == null || index == null) continue;
                Integer stateCode = this.states.computeIfAbsent(allele, a -> this.stateTable.getStateCode((String)a, true, this.ioMissingData, this.ioUseHetSep, this.ioHeteroSeparator));
                line.setLoci(index.mapIndex, index.mkrIndex, stateCode);
                ++this.alleleCount;
                if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
                return false;
            }
            if (!this.isOK) break;
        }
        return true;
    }
}

