/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorState;

public class HeterozygeousColorState
extends ColorState {
    HeterozygeousColorState(AlleleState state, Color primary, Color state1, Color state2, int w, int h) {
        super(state, primary, w, h);
        if (!Prefs.visShowHetsAsH) {
            this.image = this.createBuffer(state1, state2, false);
            this.imageUnderQTL = this.createBuffer(state1, state2, true);
        } else {
            this.image = this.createHomzBuffer(false);
            this.imageUnderQTL = this.createHomzBuffer(true);
        }
        this.createUnselectedImage(w, h);
    }

    private BufferedImage createBuffer(Color c1, Color c2, boolean isUnderQTL) {
        BufferedImage image = new BufferedImage(this.w, this.h, 1);
        Graphics2D g = image.createGraphics();
        String s1 = this.state.getState(0);
        String s2 = this.state.getState(1);
        if (Prefs.visDisableGradients) {
            this.drawState(g, c1, c1, s1, this.w, this.h, true);
            this.drawState(g, c2, c2, s2, this.w, this.h, false);
        } else {
            this.drawState(g, c1.brighter(), c1.darker(), s1, this.w, this.h, true);
            this.drawState(g, c2.brighter(), c2.darker(), s2, this.w, this.h, false);
        }
        if (isUnderQTL) {
            // empty if block
        }
        if (Prefs.visHighlightHoZ || Prefs.visHighlightGaps || alpha < 200) {
            g.setPaint(new Color(20, 20, 20, alpha));
            g.fillRect(0, 0, this.w, this.h);
        }
        g.dispose();
        return image;
    }

    private void drawState(Graphics2D g, Color c1, Color c2, String str, int w, int h, boolean lhs) {
        int[] x = null;
        int[] y = null;
        if (lhs) {
            x = new int[]{0, w, 0};
            y = new int[]{0, 0, h};
        } else {
            x = new int[]{w, 0, w};
            y = new int[]{0, h, h};
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(new GradientPaint(0.0f, 0.0f, c1, w, h, c2));
        g.fill(new Polygon(x, y, 3));
        if (Prefs.visShowGenotypes && h >= 7 && Prefs.visLinkSliders) {
            Font font = g.getFont().deriveFont(0, h - h / 2);
            g.setColor(Prefs.visColorText);
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(str, g);
            float strW2 = (float)(bounds.getWidth() / 2.0);
            float strH2 = (float)(fm.getAscent() - fm.getDescent()) / 2.0f;
            float w4 = (float)w / 4.0f;
            float h4 = (float)h / 4.0f;
            if (lhs) {
                g.drawString(str, w4 - strW2, h4 + strH2 + 1.0f);
            } else {
                g.drawString(str, w4 * 3.0f - strW2, h4 * 3.0f + strH2 - 1.0f);
            }
        }
    }

    private BufferedImage createHomzBuffer(boolean isUnderQTL) {
        BufferedImage image = new BufferedImage(this.w, this.h, 1);
        Graphics2D g = image.createGraphics();
        Color c = Prefs.visColorHetsAsH;
        Color c1 = c.brighter();
        Color c2 = c.darker();
        if (Prefs.visDisableGradients) {
            g.setColor(c);
        } else {
            g.setPaint(new GradientPaint(0.0f, 0.0f, c1, this.w, this.h, c2));
        }
        Rectangle2D.Float r = new Rectangle2D.Float(0.0f, 0.0f, this.w, this.h);
        g.fill(r);
        if (isUnderQTL) {
            // empty if block
        }
        if (Prefs.visShowGenotypes && this.h >= 7 && Prefs.visLinkSliders) {
            String str = "H";
            Font font = g.getFont().deriveFont(0, this.h - 3);
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(str, g);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Prefs.visColorText);
            g.drawString(str, (int)((double)((float)this.w / 2.0f) - bounds.getWidth() / 2.0), this.h - fm.getMaxDescent());
        }
        if (Prefs.visHighlightHoZ || Prefs.visHighlightGaps || alpha < 200) {
            g.setPaint(new Color(20, 20, 20, alpha));
            g.fillRect(0, 0, this.w, this.h);
        }
        g.dispose();
        return image;
    }
}

