/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JOptionPane;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.visualization.CanvasMouseListener;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.IOverlayRenderer;

class MineSweeper
extends MouseAdapter
implements IOverlayRenderer {
    private GenotypeCanvas canvas;
    private MinePoint[][] grid;
    private int gridCount;
    private int boxW;
    private int boxH;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private Font font;
    private int fW;
    private int fH;
    private int totalMines;
    private int minesFlagged;
    private int nonMinesCleared;
    private boolean gameOverLost;
    private boolean gameOverWon;
    private CanvasMouseListener mouseListener;

    MineSweeper(GenotypeCanvas canvas, CanvasMouseListener mouseListener) {
        this.canvas = canvas;
        this.mouseListener = mouseListener;
        canvas.overlays.add(this);
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        this.init();
    }

    private void init() {
        FontMetrics fm;
        this.boxW = this.canvas.boxW;
        this.boxH = this.canvas.boxH;
        this.x1 = 2 + this.canvas.pX1 / this.boxW;
        this.y1 = 2 + this.canvas.pY1 / this.boxH;
        this.x2 = this.canvas.boxCountX - 4;
        this.y2 = this.canvas.boxCountY - 4;
        this.createGrid(this.x2, this.y2);
        int size = 0;
        do {
            this.font = new Font("Monospaced", 1, ++size);
        } while ((fm = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(this.font)).charWidth('8') <= this.boxW && fm.getHeight() <= this.boxH);
        this.fW = fm.charWidth('8');
        this.fH = fm.getHeight();
        this.canvas.repaint();
    }

    private void createGrid(int xCount, int yCount) {
        this.grid = new MinePoint[xCount][yCount];
        this.gridCount = xCount * yCount;
        for (int x = 0; x < this.grid.length; ++x) {
            for (int y = 0; y < this.grid[x].length; ++y) {
                this.grid[x][y] = new MinePoint();
                this.grid[x][y].x = this.boxW * (this.x1 + x);
                this.grid[x][y].y = this.boxH * (this.y1 + y);
            }
        }
        this.totalMines = (int)((double)this.gridCount * 0.15);
        Random r = new Random();
        for (int i = 0; i < this.totalMines; ++i) {
            boolean placedMine = false;
            while (!placedMine) {
                int x = r.nextInt(xCount);
                int y = r.nextInt(yCount);
                if (this.grid[x][y].isMine) continue;
                placedMine = true;
                this.grid[x][y].isMine = true;
            }
        }
        for (int x = 0; x < this.grid.length; ++x) {
            for (int y = 0; y < this.grid[x].length; ++y) {
                if (this.grid[x][y].isMine) continue;
                for (int col = y - 1; col <= y + 1; ++col) {
                    for (int row = x - 1; row <= x + 1; ++row) {
                        try {
                            if (!this.grid[row][col].isMine) continue;
                            ++this.grid[x][y].mineCount;
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        this.gameOverWon = false;
        this.gameOverLost = false;
        this.minesFlagged = 0;
        this.nonMinesCleared = 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown() && e.isAltDown() && e.getClickCount() == 2) {
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            this.canvas.overlays.remove(this);
            this.canvas.addMouseListener(this.mouseListener);
        } else if (e.isAltDown() && e.getClickCount() == 2) {
            this.init();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getPoint().x / this.boxW - this.x1;
        int y = e.getPoint().y / this.boxH - this.y1;
        if (x < 0 || x >= this.grid.length || y < 0 || y >= this.grid[0].length) {
            this.canvas.repaint();
            return;
        }
        if (!this.gameOverWon && !this.gameOverLost) {
            this.grid[x][y].click(e.isMetaDown());
        }
        this.canvas.repaint();
    }

    void cascade(MinePoint m) {
        int row;
        int col;
        int x = 0;
        int y = 0;
        block2: for (col = 0; col < this.grid.length; ++col) {
            for (row = 0; row < this.grid[col].length; ++row) {
                if (this.grid[col][row] != m) continue;
                x = col;
                y = row;
                continue block2;
            }
        }
        if (m.mineCount == 0) {
            for (col = y - 1; col <= y + 1; ++col) {
                for (row = x - 1; row <= x + 1; ++row) {
                    try {
                        if (this.grid[row][col].isClear) continue;
                        this.grid[row][col].setClear();
                        this.cascade(this.grid[row][col]);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void render(Graphics2D g) {
        for (int x = 0; x < this.grid.length; ++x) {
            for (int y = 0; y < this.grid[x].length; ++y) {
                this.grid[x][y].draw(g);
            }
        }
        g.setStroke(new BasicStroke(4.0f));
        g.setColor(Color.red);
        g.drawRect(this.x1 * this.boxW, this.y1 * this.boxH, this.grid.length * this.boxW, this.grid[0].length * this.boxH);
    }

    private class MinePoint {
        int x;
        int y;
        boolean isMine = false;
        int mineCount = 0;
        boolean isClear = false;
        int state = 1;

        private MinePoint() {
        }

        void setClear() {
            if (!this.isClear) {
                this.isClear = true;
                MineSweeper.this.nonMinesCleared++;
            }
        }

        void click(boolean rightClick) {
            if (!rightClick) {
                if (this.isMine) {
                    MineSweeper.this.gameOverLost = true;
                } else if (!this.isClear) {
                    this.setClear();
                    if (this.mineCount == 0) {
                        MineSweeper.this.cascade(this);
                    }
                }
            } else {
                if (this.isMine && this.state == 2) {
                    MineSweeper.this.minesFlagged--;
                }
                ++this.state;
                if (this.state == 4) {
                    this.state = 1;
                }
                if (this.isMine && this.state == 2) {
                    MineSweeper.this.minesFlagged++;
                }
            }
            if (MineSweeper.this.minesFlagged + MineSweeper.this.nonMinesCleared == MineSweeper.this.gridCount) {
                MineSweeper.this.gameOverWon = true;
                MineSweeper.this.canvas.repaint();
                JOptionPane.showMessageDialog(Flapjack.winMain, "Well done! Now do some work.");
            }
        }

        void draw(Graphics2D g) {
            g.setColor(Color.black);
            g.setFont(MineSweeper.this.font);
            int fx = this.x + MineSweeper.this.boxW / 2 - MineSweeper.this.fW / 2;
            int fy = this.y + MineSweeper.this.boxH / 4 + MineSweeper.this.fH / 2;
            if (this.isMine && MineSweeper.this.gameOverLost) {
                g.drawString("B", fx, fy);
            } else if (this.isClear && this.mineCount == 0) {
                g.setPaint(new Color(235, 235, 235, 175));
                g.fillRect(this.x, this.y, MineSweeper.this.boxW, MineSweeper.this.boxH);
            } else if (this.isClear) {
                g.setPaint(new Color(235, 235, 235, 175));
                g.fillRect(this.x, this.y, MineSweeper.this.boxW, MineSweeper.this.boxH);
                switch (this.mineCount) {
                    case 1: {
                        g.setPaint(Color.blue);
                        break;
                    }
                    case 2: {
                        g.setPaint(Color.green);
                        break;
                    }
                    case 3: {
                        g.setPaint(Color.red);
                        break;
                    }
                    case 4: {
                        g.setPaint(Color.blue.darker());
                        break;
                    }
                    default: {
                        g.setPaint(Color.red.darker());
                    }
                }
                g.drawString("" + this.mineCount, fx, fy);
            } else if (this.state == 2) {
                g.drawString("F", fx, fy);
            } else if (this.state == 3) {
                g.drawString("?", fx, fy);
            }
            g.setColor(Color.black);
            g.drawRect(this.x, this.y, MineSweeper.this.boxW, MineSweeper.this.boxH);
        }
    }
}

