/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import jhi.flapjack.gui.table.SortColumn;
import scri.commons.gui.RB;

class SortDialogTableModel
extends AbstractTableModel {
    private SortColumn[] data;
    private ArrayList<SortColumn> rows;
    private String[] columnNames;
    private static String ASC;
    private static String DEC;

    SortDialogTableModel(SortColumn[] data, SortColumn[] lastUsed) {
        this.data = data;
        ASC = RB.getString((String)"gui.table.SortDialog.asc");
        DEC = RB.getString((String)"gui.table.SortDialog.dec");
        this.columnNames = new String[]{RB.getString((String)"gui.table.SortDialog.col1"), RB.getString((String)"gui.table.SortDialog.col2")};
        this.rows = new ArrayList();
        if (lastUsed == null) {
            this.rows.add(data[0].cloneMe());
        } else {
            for (SortColumn entry : lastUsed) {
                this.rows.add(entry.cloneMe());
            }
        }
    }

    SortColumn[] getResults() {
        return this.rows.toArray(new SortColumn[0]);
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.rows.get(row);
        }
        if (this.rows.get((int)row).sortOrder == SortOrder.ASCENDING) {
            return ASC;
        }
        return DEC;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return SortColumn.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    JComboBox<SortColumn> getColumnNameComboBox() {
        JComboBox<SortColumn> combo = new JComboBox<SortColumn>();
        for (int i = 0; i < this.data.length; ++i) {
            combo.addItem(this.data[i].cloneMe());
        }
        return combo;
    }

    JComboBox<String> getSortOrderComboBox() {
        JComboBox<String> combo = new JComboBox<String>();
        combo.addItem(DEC);
        combo.addItem(ASC);
        return combo;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        SortColumn entry = this.rows.get(row);
        if (col == 0) {
            entry.colIndex = ((SortColumn)value).colIndex;
            entry.name = ((SortColumn)value).name;
        } else {
            entry.sortOrder = ((String)value).equals(ASC) ? SortOrder.ASCENDING : SortOrder.DESCENDING;
        }
        this.fireTableCellUpdated(row, col);
    }

    void addRow() {
        this.rows.add(this.data[0].cloneMe());
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    void deleteRow(int row) {
        this.rows.remove(row);
        this.fireTableRowsDeleted(row, row);
    }
}

