/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.mabc;

import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.results.MabcChrScore;
import jhi.flapjack.data.results.MabcQtlScore;
import jhi.flapjack.data.results.MabcResult;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.table.LineDataTableModel;

public class MabcTableModel
extends LineDataTableModel {
    private int chrCount;
    private int qtlCount;
    private int rppIndex;
    private int rppTotalIndex;
    private int rppCoverageIndex;
    private int qtlIndex;
    private int qtlStatusIndex;
    private int selectedIndex;
    private int rankIndex;
    private int commentIndex;
    private int sortIndex;

    public MabcTableModel(GTViewSet viewSet) {
        this.dataSet = viewSet.getDataSet();
        this.setLines(viewSet.tableHandler().linesForTable());
        this.initModel();
    }

    void initModel() {
        LineInfo line = (LineInfo)this.lines.get(0);
        MabcResult s = line.getResults().getMabcResult();
        this.chrCount = s.getChrScores().size();
        this.qtlCount = s.getQtlScores().size();
        this.rppIndex = 1;
        this.rppTotalIndex = this.rppIndex + this.chrCount;
        this.rppCoverageIndex = this.rppTotalIndex + 1;
        this.qtlIndex = this.rppCoverageIndex + 1;
        this.qtlStatusIndex = this.qtlCount > 0 ? this.qtlIndex + this.qtlCount * 2 : -1;
        this.selectedIndex = this.qtlCount > 0 ? this.qtlStatusIndex + 1 : this.qtlIndex;
        this.rankIndex = this.selectedIndex + 1;
        this.commentIndex = this.rankIndex + 1;
        this.sortIndex = this.commentIndex + 1;
        int colCount = this.sortIndex + 1;
        this.columnNames = new String[colCount];
        this.ttNames = new String[colCount];
        this.columnNames[0] = "Line";
        for (int i = 0; i < s.getChrScores().size(); ++i) {
            MabcChrScore cs = s.getChrScores().get(i);
            this.columnNames[this.rppIndex + i] = "RPP (" + cs.view.getChromosomeMap().getName() + ")";
            this.ttNames[this.rppIndex + i] = "Recurrent Parent Percentage (" + cs.view.getChromosomeMap().getName() + ")";
        }
        this.columnNames[this.rppTotalIndex] = "RPP Total";
        this.columnNames[this.rppCoverageIndex] = "RPP Coverage";
        int qtl = 0;
        for (MabcQtlScore score : s.getQtlScores()) {
            this.columnNames[this.qtlIndex + qtl * 2] = "LD (" + score.qtl.getQTL().getName() + ")";
            this.ttNames[this.qtlIndex + qtl * 2] = "Linkage Drag (" + score.qtl.getQTL().getName() + ")";
            this.columnNames[this.qtlIndex + qtl * 2 + 1] = "Status (" + score.qtl.getQTL().getName() + ")";
            ++qtl;
        }
        if (this.qtlStatusIndex != -1) {
            this.columnNames[this.qtlStatusIndex] = "QTL Allele Count";
        }
        this.columnNames[this.selectedIndex] = "Selected";
        this.columnNames[this.rankIndex] = "Rank";
        this.columnNames[this.commentIndex] = "Comments";
        this.columnNames[this.sortIndex] = "Don't Sort/Filter";
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.ttNames[i] != null) continue;
            this.ttNames[i] = this.columnNames[i];
        }
    }

    @Override
    public boolean skipExport(int col) {
        return col == this.sortIndex;
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public Object getObjectAt(int row, int col) {
        LineInfo line = (LineInfo)this.lines.get(row);
        MabcResult stats = line.getResults().getMabcResult();
        if (col == 0) {
            return line;
        }
        if (col == this.selectedIndex) {
            return line.getSelected();
        }
        if (col == this.sortIndex) {
            return line.getResults().isSortToTop();
        }
        if (stats == null) {
            return null;
        }
        if (col >= this.rppIndex && col < this.rppTotalIndex) {
            return stats.getChrScores().get((int)(col - this.rppIndex)).sumRP;
        }
        if (col == this.rppTotalIndex) {
            return stats.getRppTotal();
        }
        if (col == this.rppCoverageIndex) {
            return stats.getGenomeCoverage();
        }
        if (col >= this.qtlIndex && col < this.qtlStatusIndex) {
            int qtl = (col -= this.qtlIndex) / 2;
            MabcQtlScore score = stats.getQtlScores().get(qtl);
            if (col % 2 == 0) {
                return score.drag;
            }
            return score.status;
        }
        if (col == this.qtlStatusIndex) {
            return stats.getQtlStatusCount();
        }
        if (col == this.rankIndex) {
            return line.getResults().getRank();
        }
        if (col == this.commentIndex) {
            String comment = line.getResults().getComments();
            return comment == null ? "" : comment;
        }
        return null;
    }

    @Override
    public Class getObjectColumnClass(int col) {
        if (col == 0) {
            return LineInfo.class;
        }
        if (col == this.commentIndex) {
            return String.class;
        }
        if (col == this.selectedIndex || col == this.sortIndex) {
            return Boolean.class;
        }
        if (col == this.rankIndex) {
            return Integer.class;
        }
        return Double.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == this.selectedIndex || col == this.rankIndex || col == this.commentIndex || col == this.sortIndex;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        LineInfo line = (LineInfo)this.getObjectAt(row, 0);
        MabcResult stats = line.getResults().getMabcResult();
        if (col == this.selectedIndex) {
            MabcTableModel.selectLine(line, (Boolean)value);
        } else if (col == this.rankIndex) {
            line.getResults().setRank((Integer)value);
        } else if (col == this.commentIndex) {
            line.getResults().setComments((String)value);
        } else if (col == this.sortIndex) {
            line.getResults().setSortToTop((Boolean)value);
        }
        this.fireTableRowsUpdated(row, row);
        Actions.projectModified();
    }

    int selectQTL(int number) {
        int selectedCount = 0;
        for (int row = 0; row < this.getRowCount(); ++row) {
            if ((Integer)this.getValueAt(row, this.qtlStatusIndex) >= number) {
                this.setValueAt(true, row, this.selectedIndex);
                ++selectedCount;
            } else {
                this.setValueAt(false, row, this.selectedIndex);
            }
            this.fireTableRowsUpdated(row, row);
        }
        return selectedCount;
    }

    void setRank(int row, int rank) {
        this.setValueAt(rank, row, this.rankIndex);
        this.fireTableRowsUpdated(row, row);
    }
}

