/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.dialog.analysis.ChromosomeSelectionDialog;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class FilterMarkersByLineDialog
extends JDialog
implements ActionListener {
    private GTViewSet viewSet;
    private ChromosomeSelectionDialog csd;
    private GenotypePanel gPanel;
    private boolean isOK;
    private String label;
    private JButton bCancel;
    private JButton bFilter;
    private JButton bHelp;
    private HyperLinkLabel csdLabel;
    private JPanel dataPanel;
    private DialogPanel dialogPanel1;
    private JLabel lineLabel;
    private JPanel linePanel;
    JComboBox<LineInfo> selectedLine;

    public FilterMarkersByLineDialog(GenotypePanel gPanel, GTViewSet viewSet, String title, String label) {
        super(Flapjack.winMain, title, true);
        this.gPanel = gPanel;
        this.viewSet = viewSet;
        this.label = label;
        this.isOK = false;
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bFilter, this.bCancel, true, this.getContentPane(), this.linePanel, this.dataPanel);
    }

    private void initComponents2() {
        this.bFilter.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "_-_Filtering_Markers");
        this.lineLabel.setText(this.label);
        this.csd = new ChromosomeSelectionDialog(this.viewSet, false);
        this.csd.hideLineSummary();
        this.csdLabel.addActionListener(e -> this.csd.setVisible(true));
        GTView view = this.viewSet.getView(this.viewSet.getViewIndex());
        DefaultComboBoxModel<LineInfo> lineModel = new DefaultComboBoxModel<LineInfo>();
        AnalysisSet as = new AnalysisSet(this.viewSet).withViews(null).withAllLines().withSelectedMarkers();
        for (int i = 0; i < as.lineCount(); ++i) {
            lineModel.addElement(as.getLine(i));
        }
        this.selectedLine.setModel(lineModel);
        if (view.mouseOverLine >= 0 && view.mouseOverLine < view.lineCount()) {
            this.selectedLine.setSelectedIndex(view.mouseOverLine);
        }
        if (this.viewSet.getView(0).countSelectedLines() == 0) {
            this.bFilter.setEnabled(false);
        }
    }

    public boolean[] getSelectedChromosomes() {
        return this.csd.getSelectedChromosomes();
    }

    public LineInfo getSelectedLine() {
        return (LineInfo)this.selectedLine.getSelectedItem();
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bFilter) {
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bFilter = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.linePanel = new JPanel();
        this.selectedLine = new JComboBox();
        this.lineLabel = new JLabel();
        this.dataPanel = new JPanel();
        this.csdLabel = new HyperLinkLabel();
        this.setDefaultCloseOperation(2);
        this.bFilter.setText("Filter");
        this.dialogPanel1.add((Component)this.bFilter);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.linePanel.setBorder(BorderFactory.createTitledBorder("Reference line:"));
        this.lineLabel.setText("Remove all markers with missing data in this line:");
        GroupLayout linePanelLayout = new GroupLayout(this.linePanel);
        this.linePanel.setLayout(linePanelLayout);
        linePanelLayout.setHorizontalGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linePanelLayout.createSequentialGroup().addContainerGap().addGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linePanelLayout.createSequentialGroup().addComponent(this.lineLabel).addGap(0, 66, Short.MAX_VALUE)).addComponent(this.selectedLine, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        linePanelLayout.setVerticalGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedLine, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data selection settings:"));
        this.csdLabel.setText("Select chromosomes to filter across");
        GroupLayout dataPanelLayout = new GroupLayout(this.dataPanel);
        this.dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        dataPanelLayout.setVerticalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.csdLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.linePanel, -1, -1, Short.MAX_VALUE).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.linePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, -1, -2)));
        this.pack();
    }
}

