/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.colors.AlleleFrequencyColorScheme;
import jhi.flapjack.gui.visualization.colors.BinnedColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.LineSimilarityColorScheme;
import jhi.flapjack.gui.visualization.colors.LineSimilarityExactColorScheme;
import jhi.flapjack.gui.visualization.colors.MagicColorScheme;
import jhi.flapjack.gui.visualization.colors.MarkerSimilarityColorScheme;
import jhi.flapjack.gui.visualization.colors.Nucleotide01ColorScheme;
import jhi.flapjack.gui.visualization.colors.NucleotideColorScheme;
import jhi.flapjack.gui.visualization.colors.RandomColorScheme;
import jhi.flapjack.gui.visualization.colors.SimpleTwoColorScheme;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;

public class ColorDialog
extends JDialog
implements ActionListener {
    private WinMain winMain;
    private GenotypePanel gPanel;
    private DefaultComboBoxModel<ColorScheme> comboModel;
    private DefaultListModel<ColorScheme.ColorSummary> standardModel;
    private DefaultListModel<ColorScheme.ColorSummary> schemeModel;
    private JButton bApply;
    private JButton bClose;
    private JButton bDefaults;
    private JButton bHelp;
    private JCheckBox checkHetAsH;
    private JPanel colorPanel;
    private JLabel comboLabel;
    private DialogPanel dialogPanel1;
    private JPanel gridPanel;
    private JPanel infoPanel;
    private JTextArea infoText;
    private JLabel listLabel1;
    private JLabel listLabel2;
    JComboBox<ColorScheme> schemeCombo;
    private JList<ColorScheme.ColorSummary> schemeList;
    private JList<ColorScheme.ColorSummary> standardList;

    public ColorDialog(WinMain winMain, GenotypePanel gPanel) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.ColorDialog.title"), true);
        this.winMain = winMain;
        this.gPanel = gPanel;
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bClose, this.bClose, true, this.getContentPane(), this.gridPanel, this.infoPanel, this.colorPanel);
    }

    private void initComponents2() {
        RB.setText((AbstractButton)this.bClose, (String)"gui.text.close");
        this.bClose.addActionListener(this);
        RB.setText((AbstractButton)this.bDefaults, (String)"gui.dialog.ColorDialog.bDefaults");
        RB.setMnemonic((AbstractButton)this.bDefaults, (String)"gui.dialog.ColorDialog.bDefaults");
        this.bDefaults.addActionListener(this);
        RB.setText((AbstractButton)this.bApply, (String)"gui.dialog.ColorDialog.bApply");
        RB.setMnemonic((AbstractButton)this.bApply, (String)"gui.dialog.ColorDialog.bApply");
        this.bApply.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "_-_Customize_Colours");
        RB.setText((JLabel)this.comboLabel, (String)"gui.dialog.NBColorPanel.comboLabel");
        this.infoPanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBColorPanel.infoPanel.title")));
        this.colorPanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBColorPanel.colorPanel.title")));
        RB.setText((JLabel)this.listLabel1, (String)"gui.dialog.NBColorPanel.listLabel1");
        RB.setText((JLabel)this.listLabel2, (String)"gui.dialog.NBColorPanel.listLabel2");
        this.standardList.setCellRenderer(new ColorListRenderer());
        this.schemeList.setCellRenderer(new ColorListRenderer());
        this.addMouseListener(this.standardList);
        this.addMouseListener(this.schemeList);
        this.comboModel = new DefaultComboBoxModel();
        this.comboModel.addElement(new NucleotideColorScheme());
        this.comboModel.addElement(new Nucleotide01ColorScheme());
        this.comboModel.addElement(new SimpleTwoColorScheme());
        this.comboModel.addElement(new LineSimilarityColorScheme());
        this.comboModel.addElement(new LineSimilarityExactColorScheme());
        this.comboModel.addElement(new MarkerSimilarityColorScheme());
        this.comboModel.addElement(new AlleleFrequencyColorScheme());
        this.comboModel.addElement(new MagicColorScheme());
        this.comboModel.addElement(new BinnedColorScheme());
        this.comboModel.addElement(new RandomColorScheme(50));
        this.comboModel.addElement(new RandomColorScheme(51));
        this.schemeCombo.setModel(this.comboModel);
        this.schemeCombo.addActionListener(this);
        this.initializeLists();
        int model = this.gPanel.getViewSet().getColorScheme();
        for (int i = 0; i < this.comboModel.getSize(); ++i) {
            if (this.comboModel.getElementAt(i).getModel() != model) continue;
            this.schemeCombo.setSelectedIndex(i);
        }
        this.checkHetAsH.setSelected(Prefs.visShowHetsAsH);
        this.checkHetAsH.addActionListener(e -> this.toggleHets());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bClose) {
            this.setVisible(false);
        } else if (e.getSource() == this.bApply) {
            ColorScheme cs = (ColorScheme)this.schemeCombo.getSelectedItem();
            this.winMain.mViz.vizColor(cs.getModel());
            if ((e.getModifiers() & 1) != 0 && cs instanceof RandomColorScheme) {
                new RandomDemo().start();
            }
        } else if (e.getSource() == this.bDefaults) {
            String[] options;
            String msg = RB.getString((String)"gui.dialog.ColorDialog.defaultsMsg");
            if (TaskDialog.show((String)msg, (int)2, (int)1, (String[])(options = new String[]{RB.getString((String)"gui.dialog.ColorDialog.bDefaults"), RB.getString((String)"gui.text.cancel")})) == 0) {
                this.resetColors();
            }
        } else if (e.getSource() == this.schemeCombo) {
            this.updateSchemeList();
        }
    }

    void initializeLists() {
        this.initStandardList();
        this.updateSchemeList();
    }

    private void initStandardList() {
        this.standardModel = new DefaultListModel();
        for (ColorScheme.ColorSummary summary : ColorScheme.getStandardColorSummaries()) {
            this.standardModel.addElement(summary);
        }
        this.standardList.setModel(this.standardModel);
    }

    private void updateSchemeList() {
        ColorScheme cs = (ColorScheme)this.schemeCombo.getSelectedItem();
        this.infoText.setText(cs.getDescription());
        this.infoText.setCaretPosition(0);
        this.schemeModel = new DefaultListModel();
        for (ColorScheme.ColorSummary summary : cs.getColorSummaries()) {
            this.schemeModel.addElement(summary);
        }
        this.schemeList.setModel(this.schemeModel);
    }

    private void toggleHets() {
        Prefs.visShowHetsAsH = this.checkHetAsH.isSelected();
        this.gPanel.setViewSet(this.gPanel.getViewSet());
    }

    private void addMouseListener(final JList list) {
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColorDialog.this.selectColor(list);
                }
            }
        });
    }

    private void selectColor(JList list) {
        ColorScheme.ColorSummary c = (ColorScheme.ColorSummary)list.getSelectedValue();
        if (c == null) {
            return;
        }
        Color newColor = JColorChooser.showDialog(this, "Select New Colour", c.color);
        if (newColor == null) {
            return;
        }
        c.color = newColor;
        if (list == this.standardList) {
            ColorScheme.setStandardColorSummaries(this.getVector(this.standardModel));
        } else {
            ColorScheme cs = (ColorScheme)this.schemeCombo.getSelectedItem();
            cs.setColorSummaries(this.getVector(this.schemeModel));
        }
        this.gPanel.setViewSet(this.gPanel.getViewSet());
    }

    private ArrayList<ColorScheme.ColorSummary> getVector(DefaultListModel model) {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        for (int i = 0; i < model.size(); ++i) {
            colors.add((ColorScheme.ColorSummary)model.get(i));
        }
        return colors;
    }

    void resetColors() {
        Prefs.setColorDefaults();
        this.initializeLists();
        this.gPanel.setViewSet(this.gPanel.getViewSet());
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        JScrollPane sp1 = new JScrollPane();
        this.infoText = new JTextArea();
        this.comboLabel = new JLabel();
        this.schemeCombo = new JComboBox();
        this.colorPanel = new JPanel();
        this.gridPanel = new JPanel();
        JPanel panel1 = new JPanel();
        JScrollPane sp2 = new JScrollPane();
        this.standardList = new JList();
        this.listLabel1 = new JLabel();
        JPanel panel2 = new JPanel();
        this.listLabel2 = new JLabel();
        JScrollPane sp3 = new JScrollPane();
        this.schemeList = new JList();
        this.checkHetAsH = new JCheckBox();
        this.dialogPanel1 = new DialogPanel();
        this.bApply = new JButton();
        this.bDefaults = new JButton();
        this.bClose = new JButton();
        this.bHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.infoPanel.setBorder(BorderFactory.createTitledBorder("Information:"));
        sp1.setHorizontalScrollBarPolicy(31);
        this.infoText.setColumns(20);
        this.infoText.setEditable(false);
        this.infoText.setLineWrap(true);
        this.infoText.setRows(5);
        this.infoText.setWrapStyleWord(true);
        sp1.setViewportView(this.infoText);
        this.comboLabel.setText("Selected colour scheme:");
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addContainerGap().addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addComponent(this.comboLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.schemeCombo, 0, 372, Short.MAX_VALUE)).addComponent(sp1, -1, 498, Short.MAX_VALUE)).addContainerGap()));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboLabel).addComponent(this.schemeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(sp1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.colorPanel.setBorder(BorderFactory.createTitledBorder("Customize (double click a colour to change it):"));
        this.gridPanel.setLayout(new GridLayout(1, 2, 10, 0));
        panel1.setBackground((Color)UIManager.get("fjDialogBG"));
        panel1.setLayout(new BorderLayout(0, 5));
        sp2.setViewportView(this.standardList);
        panel1.add((Component)sp2, "Center");
        this.listLabel1.setText("Standard colours:");
        panel1.add((Component)this.listLabel1, "North");
        this.gridPanel.add(panel1);
        panel2.setBackground((Color)UIManager.get("fjDialogBG"));
        panel2.setLayout(new BorderLayout(0, 5));
        this.listLabel2.setText("Scheme specific:");
        panel2.add((Component)this.listLabel2, "North");
        sp3.setViewportView(this.schemeList);
        panel2.add((Component)sp3, "Center");
        this.gridPanel.add(panel2);
        this.checkHetAsH.setText("Always render heterozygotes as single-colour 'H' blocks, regardless of the scheme selected");
        GroupLayout colorPanelLayout = new GroupLayout(this.colorPanel);
        this.colorPanel.setLayout(colorPanelLayout);
        colorPanelLayout.setHorizontalGroup(colorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(colorPanelLayout.createSequentialGroup().addContainerGap().addGroup(colorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gridPanel, -1, 498, Short.MAX_VALUE).addGroup(colorPanelLayout.createSequentialGroup().addComponent(this.checkHetAsH).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        colorPanelLayout.setVerticalGroup(colorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(colorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.gridPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkHetAsH).addContainerGap()));
        this.bApply.setText("Apply to current view");
        this.dialogPanel1.add((Component)this.bApply);
        this.bDefaults.setText("Reset colours");
        this.dialogPanel1.add((Component)this.bDefaults);
        this.bClose.setText("Close");
        this.dialogPanel1.add((Component)this.bClose);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.colorPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.infoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.infoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }

    static class ColorListRenderer
    extends DefaultListCellRenderer {
        ColorListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object o, int i, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, o, i, iss, chf);
            ColorScheme.ColorSummary summary = (ColorScheme.ColorSummary)o;
            this.setText(summary.name);
            BufferedImage image = new BufferedImage(20, 10, 1);
            Graphics2D g = image.createGraphics();
            Color c1 = summary.color.brighter();
            Color c2 = summary.color.darker();
            g.setPaint(new GradientPaint(0.0f, 0.0f, c1, 20.0f, 10.0f, c2));
            g.fillRect(0, 0, 20, 10);
            g.setColor(Color.black);
            g.drawRect(0, 0, 20, 10);
            g.dispose();
            this.setIcon(new ImageIcon(image));
            return this;
        }

        @Override
        public Insets getInsets(Insets i) {
            return new Insets(0, 3, 0, 0);
        }
    }

    private class RandomDemo
    extends Thread {
        private RandomDemo() {
        }

        @Override
        public void run() {
            Runnable r = () -> ((ColorDialog)ColorDialog.this).winMain.mViz.vizColor(50);
            for (int i = 0; i < 50; ++i) {
                try {
                    SwingUtilities.invokeAndWait(r);
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

