/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HistoryComboBox;

public class BrowseDialog
extends JDialog
implements ActionListener {
    private boolean isOK = false;
    private String fileHistory;
    private String rbLabel;
    private String rbButton;
    private String help;
    private JButton bBrowse;
    private JButton bCancel;
    private JButton bHelp;
    private JButton bImport;
    HistoryComboBox browseComboBox;
    private DialogPanel dialogPanel1;
    private JLabel label;
    private JPanel panel;

    public BrowseDialog(String fileHistory, String rbTitle, String rbLabel, String rbButton, String help) {
        super(Flapjack.winMain, RB.getString((String)rbTitle), true);
        this.fileHistory = fileHistory;
        this.rbLabel = rbLabel;
        this.rbButton = rbButton;
        this.help = help;
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bImport, this.bCancel, true, this.getContentPane(), this.panel);
    }

    private void initComponents2() {
        RB.setText((AbstractButton)this.bImport, (String)this.rbButton);
        this.bImport.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        this.bHelp.addActionListener(this);
        FlapjackUtils.setHelp(this.bHelp, this.help);
        this.panel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBBrowsePanel.panel.title")));
        RB.setText((JLabel)this.label, (String)this.rbLabel);
        RB.setText((AbstractButton)this.bBrowse, (String)"gui.text.browse");
        this.bBrowse.addActionListener(this);
        this.browseComboBox.setHistory(this.fileHistory);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bImport && this.browseNotEmpty()) {
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        } else if (e.getSource() == this.bBrowse) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(RB.getString((String)"gui.dialog.NBDataImportPanel.fcTitle"));
            fc.setCurrentDirectory(new File(Prefs.guiCurrentDir));
            if (this.browseComboBox.getText().length() > 0) {
                fc.setCurrentDirectory(new File(this.browseComboBox.getText()));
            }
            if (fc.showOpenDialog(this) == 0) {
                File file = fc.getSelectedFile();
                Prefs.guiCurrentDir = fc.getCurrentDirectory().toString();
                this.browseComboBox.updateComboBox(file.toString());
            }
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public File getFile() {
        return new File(this.browseComboBox.getText());
    }

    public String getHistory() {
        return this.browseComboBox.getHistory();
    }

    boolean browseNotEmpty() {
        if (this.browseComboBox.getText().length() == 0) {
            TaskDialog.warning((String)RB.getString((String)"gui.dialog.NBBrowsePanel.warning"), (String)RB.getString((String)"gui.text.ok"));
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.label = new JLabel();
        this.bBrowse = new JButton();
        this.browseComboBox = new HistoryComboBox();
        this.dialogPanel1 = new DialogPanel();
        this.bImport = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.panel.setBorder(BorderFactory.createTitledBorder("Browse for file:"));
        this.label.setText("File to import:");
        this.bBrowse.setText("Browse...");
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.browseComboBox, -1, 313, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bBrowse).addContainerGap()));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.label).addComponent(this.bBrowse).addComponent((Component)this.browseComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.bImport.setText("Import");
        this.dialogPanel1.add((Component)this.bImport);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }
}

