/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.engine.header.ContentTypeReader;
import org.restlet.representation.Representation;

public class ContentType {
    private volatile CharacterSet characterSet;
    private volatile MediaType mediaType;

    public static CharacterSet readCharacterSet(String contentType) {
        return new ContentType(contentType).getCharacterSet();
    }

    public static MediaType readMediaType(String contentType) {
        return new ContentType(contentType).getMediaType();
    }

    public static String writeHeader(MediaType mediaType, CharacterSet characterSet) {
        String result = mediaType.toString();
        if (mediaType.getParameters().getFirstValue("charset") == null && characterSet != null) {
            result = result + "; charset=" + characterSet.getName();
        }
        return result;
    }

    public static String writeHeader(Representation representation) {
        return ContentType.writeHeader(representation.getMediaType(), representation.getCharacterSet());
    }

    public ContentType(MediaType mediaType, CharacterSet characterSet) {
        this.mediaType = mediaType;
        this.characterSet = characterSet;
    }

    public ContentType(Representation representation) {
        this(representation.getMediaType(), representation.getCharacterSet());
    }

    public ContentType(String headerValue) {
        try {
            ContentTypeReader ctr = new ContentTypeReader(headerValue);
            ContentType ct = ctr.readValue();
            if (ct != null) {
                this.mediaType = ct.getMediaType();
                this.characterSet = ct.getCharacterSet();
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("The Content Type could not be read.", ioe);
        }
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String toString() {
        return ContentType.writeHeader(this.getMediaType(), this.getCharacterSet());
    }
}

