/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Expectation;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.data.Warning;
import org.restlet.representation.Representation;
import org.restlet.security.Role;
import org.restlet.util.Series;

public class Request
extends Message {
    private volatile Set<String> accessControlRequestHeaders = null;
    private volatile Method accessControlRequestMethod = null;
    private volatile ChallengeResponse challengeResponse = null;
    private volatile ClientInfo clientInfo = null;
    private volatile Conditions conditions = null;
    private volatile Series<Cookie> cookies = null;
    private volatile Reference hostRef = null;
    private volatile boolean loggable = true;
    private volatile int maxForwards = -1;
    private volatile Method method;
    private volatile Uniform onResponse;
    private volatile Reference originalRef;
    private volatile Protocol protocol;
    private volatile ChallengeResponse proxyChallengeResponse;
    private volatile List<Range> ranges;
    private volatile Reference referrerRef;
    private volatile Reference resourceRef;
    private volatile Reference rootRef;

    public static Request getCurrent() {
        return Response.getCurrent() == null ? null : Response.getCurrent().getRequest();
    }

    public Request() {
        this((Method)null, (Reference)null, (Representation)null);
    }

    public Request(Method method, Reference resourceRef) {
        this(method, resourceRef, null);
    }

    public Request(Method method, Reference resourceRef, Representation entity) {
        super(entity);
        this.method = method;
        this.originalRef = null;
        this.onResponse = null;
        this.proxyChallengeResponse = null;
        this.protocol = null;
        this.ranges = null;
        this.referrerRef = null;
        this.resourceRef = resourceRef;
        this.rootRef = null;
    }

    public Request(Method method, String resourceUri) {
        this(method, new Reference(resourceUri));
    }

    public Request(Method method, String resourceUri, Representation entity) {
        this(method, new Reference(resourceUri), entity);
    }

    public Request(Request request) {
        this(request.getMethod(), new Reference(request.getResourceRef()), request.getEntity());
        this.challengeResponse = request.getChallengeResponse();
        ClientInfo rci = request.getClientInfo();
        this.clientInfo = new ClientInfo();
        for (Preference<CharacterSet> preference : rci.getAcceptedCharacterSets()) {
            this.clientInfo.getAcceptedCharacterSets().add(preference);
        }
        for (Preference<Metadata> preference : rci.getAcceptedEncodings()) {
            this.clientInfo.getAcceptedEncodings().add(preference);
        }
        for (Preference<Metadata> preference : rci.getAcceptedLanguages()) {
            this.clientInfo.getAcceptedLanguages().add(preference);
        }
        for (Preference<Metadata> preference : rci.getAcceptedMediaTypes()) {
            this.clientInfo.getAcceptedMediaTypes().add(preference);
        }
        this.clientInfo.setAddress(rci.getAddress());
        this.clientInfo.setAgent(rci.getAgent());
        for (String string : rci.getForwardedAddresses()) {
            this.clientInfo.getForwardedAddresses().add(string);
        }
        this.clientInfo.setFrom(rci.getFrom());
        this.clientInfo.setPort(rci.getPort());
        this.clientInfo.setAgentAttributes(rci.getAgentAttributes());
        this.clientInfo.setAgentProducts(rci.getAgentProducts());
        this.clientInfo.setAuthenticated(rci.isAuthenticated());
        for (Expectation expectation : rci.getExpectations()) {
            this.clientInfo.getExpectations().add(expectation);
        }
        for (Principal principal : rci.getPrincipals()) {
            this.clientInfo.getPrincipals().add(principal);
        }
        for (Role role : rci.getRoles()) {
            this.clientInfo.getRoles().add(role);
        }
        this.clientInfo.setUser(rci.getUser());
        this.conditions = new Conditions();
        for (Tag tag : request.getConditions().getMatch()) {
            this.conditions.getMatch().add(tag);
        }
        this.conditions.setModifiedSince(request.getConditions().getModifiedSince());
        for (Tag tag : request.getConditions().getNoneMatch()) {
            this.conditions.getNoneMatch().add(tag);
        }
        this.conditions.setRangeDate(request.getConditions().getRangeDate());
        this.conditions.setRangeTag(request.getConditions().getRangeTag());
        this.conditions.setUnmodifiedSince(request.getConditions().getUnmodifiedSince());
        for (Cookie cookie : request.getCookies()) {
            this.getCookies().add(cookie);
        }
        this.hostRef = request.getHostRef();
        this.maxForwards = request.getMaxForwards();
        this.originalRef = request.getOriginalRef() == null ? null : new Reference(request.getOriginalRef());
        this.onResponse = request.getOnResponse();
        this.proxyChallengeResponse = request.getProxyChallengeResponse();
        this.protocol = request.getProtocol();
        for (Range range : request.getRanges()) {
            this.getRanges().add(range);
        }
        this.referrerRef = request.getReferrerRef() == null ? null : new Reference(request.getReferrerRef());
        this.rootRef = request.getRootRef() == null ? null : request.getRootRef();
        for (Map.Entry entry : request.getAttributes().entrySet()) {
            this.getAttributes().put((String)entry.getKey(), entry.getValue());
        }
        for (CacheDirective cacheDirective : request.getCacheDirectives()) {
            this.getCacheDirectives().add(cacheDirective);
        }
        this.setOnSent(request.getOnSent());
        for (Warning warning : request.getWarnings()) {
            this.getWarnings().add(warning);
        }
        this.setDate(request.getDate());
    }

    public boolean abort() {
        return false;
    }

    public void commit(Response response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAccessControlRequestHeaders() {
        Set<String> a = this.accessControlRequestHeaders;
        if (a == null) {
            Request request = this;
            synchronized (request) {
                a = this.accessControlRequestHeaders;
                if (a == null) {
                    this.accessControlRequestHeaders = a = new CopyOnWriteArraySet<String>();
                }
            }
        }
        return a;
    }

    public Method getAccessControlRequestMethod() {
        return this.accessControlRequestMethod;
    }

    public ChallengeResponse getChallengeResponse() {
        return this.challengeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo getClientInfo() {
        ClientInfo c = this.clientInfo;
        if (c == null) {
            Request request = this;
            synchronized (request) {
                c = this.clientInfo;
                if (c == null) {
                    this.clientInfo = c = new ClientInfo();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conditions getConditions() {
        Conditions c = this.conditions;
        if (c == null) {
            Request request = this;
            synchronized (request) {
                c = this.conditions;
                if (c == null) {
                    this.conditions = c = new Conditions();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Series<Cookie> getCookies() {
        Series<Cookie> c = this.cookies;
        if (c == null) {
            Request request = this;
            synchronized (request) {
                c = this.cookies;
                if (c == null) {
                    this.cookies = c = new Series<Cookie>(Cookie.class);
                }
            }
        }
        return c;
    }

    public Reference getHostRef() {
        return this.hostRef;
    }

    public int getMaxForwards() {
        return this.maxForwards;
    }

    public Method getMethod() {
        return this.method;
    }

    public Uniform getOnResponse() {
        return this.onResponse;
    }

    public Reference getOriginalRef() {
        return this.originalRef;
    }

    public Protocol getProtocol() {
        Protocol result = this.protocol;
        if (result == null && this.getResourceRef() != null && (result = this.getResourceRef().getSchemeProtocol()) == null) {
            result = this.getResourceRef().getBaseRef() != null ? this.getResourceRef().getBaseRef().getSchemeProtocol() : null;
        }
        return result;
    }

    public ChallengeResponse getProxyChallengeResponse() {
        return this.proxyChallengeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Range> getRanges() {
        List<Range> r = this.ranges;
        if (r == null) {
            Request request = this;
            synchronized (request) {
                r = this.ranges;
                if (r == null) {
                    this.ranges = r = new CopyOnWriteArrayList<Range>();
                }
            }
        }
        return r;
    }

    public Reference getReferrerRef() {
        return this.referrerRef;
    }

    public Reference getResourceRef() {
        return this.resourceRef;
    }

    public Reference getRootRef() {
        return this.rootRef;
    }

    public boolean isAsynchronous() {
        return this.getOnResponse() != null;
    }

    @Override
    public boolean isConfidential() {
        return this.getProtocol() == null ? false : this.getProtocol().isConfidential();
    }

    @Override
    public boolean isEntityAvailable() {
        boolean result;
        boolean bl = result = Method.GET.equals(this.getMethod()) || Method.HEAD.equals(this.getMethod());
        if (result) {
            return false;
        }
        return super.isEntityAvailable();
    }

    public boolean isExpectingResponse() {
        return this.getMethod() == null ? false : this.getMethod().isReplying();
    }

    public boolean isLoggable() {
        return this.loggable;
    }

    public boolean isSynchronous() {
        return this.getOnResponse() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessControlRequestHeaders(Set<String> accessControlRequestHeaders) {
        Set<String> set = this.getAccessControlRequestHeaders();
        synchronized (set) {
            if (accessControlRequestHeaders != this.accessControlRequestHeaders) {
                this.accessControlRequestHeaders.clear();
                if (accessControlRequestHeaders != null) {
                    this.accessControlRequestHeaders.addAll(accessControlRequestHeaders);
                }
            }
        }
    }

    public void setAccessControlRequestMethod(Method accessControlRequestMethod) {
        this.accessControlRequestMethod = accessControlRequestMethod;
    }

    public void setChallengeResponse(ChallengeResponse challengeResponse) {
        this.challengeResponse = challengeResponse;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCookies(Series<Cookie> cookies) {
        Series<Cookie> series = this.getCookies();
        synchronized (series) {
            if (cookies != this.getCookies()) {
                if (this.getCookies() != null) {
                    this.getCookies().clear();
                }
                if (cookies != null) {
                    this.getCookies().addAll(cookies);
                }
            }
        }
    }

    public void setHostRef(Reference hostRef) {
        this.hostRef = hostRef;
    }

    public void setHostRef(String hostUri) {
        this.setHostRef(new Reference(hostUri));
    }

    public void setLoggable(boolean loggable) {
        this.loggable = loggable;
    }

    public void setMaxForwards(int maxForwards) {
        this.maxForwards = maxForwards;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setOnResponse(Uniform onResponseCallback) {
        this.onResponse = onResponseCallback;
    }

    public void setOriginalRef(Reference originalRef) {
        this.originalRef = originalRef;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProxyChallengeResponse(ChallengeResponse challengeResponse) {
        this.proxyChallengeResponse = challengeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRanges(List<Range> ranges) {
        List<Range> list = this.getRanges();
        synchronized (list) {
            if (ranges != this.getRanges()) {
                this.getRanges().clear();
                if (ranges != null) {
                    this.getRanges().addAll(ranges);
                }
            }
        }
    }

    public void setReferrerRef(Reference referrerRef) {
        this.referrerRef = referrerRef;
        if (this.referrerRef != null && this.referrerRef.getFragment() != null) {
            this.referrerRef.setFragment(null);
        }
    }

    public void setReferrerRef(String referrerUri) {
        this.setReferrerRef(new Reference(referrerUri));
    }

    public void setResourceRef(Reference resourceRef) {
        this.resourceRef = resourceRef;
    }

    public void setResourceRef(String resourceUri) {
        if (this.getResourceRef() != null) {
            this.setResourceRef(new Reference(this.getResourceRef().getBaseRef(), resourceUri));
        } else {
            this.setResourceRef(new Reference(resourceUri));
        }
    }

    public void setRootRef(Reference rootRef) {
        this.rootRef = rootRef;
    }

    public String toString() {
        return (this.getMethod() == null ? "" : this.getMethod().toString()) + " " + (this.getResourceRef() == null ? "" : this.getResourceRef().toString()) + " " + (this.getProtocol() == null ? "" : this.getProtocol().getName() + (this.getProtocol().getVersion() == null ? "" : "/" + this.getProtocol().getVersion()));
    }
}

