/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class IntertekFavAlleleHeaderCreator {
    private String genotypeFileName;
    private String intertekFileName;
    private String outputFileName;
    private Map<String, IntertekMarker> intertekMarkers;
    private HashSet<String> genotypeMarkers;

    public static void main(String[] args) {
        Options options = IntertekFavAlleleHeaderCreator.mainOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cl = parser.parse(options, args);
            IntertekFavAlleleHeaderCreator intertekParser = new IntertekFavAlleleHeaderCreator(cl.getOptionValue("g"), cl.getOptionValue("i"), cl.getOptionValue("o"));
            intertekParser.parse();
        }
        catch (ParseException e) {
            IntertekFavAlleleHeaderCreator.printHelp("IntertekParser");
            e.printStackTrace();
        }
    }

    public IntertekFavAlleleHeaderCreator(String genotypeFileName, String intertekFileName, String outputFileName) {
        this.genotypeFileName = genotypeFileName;
        this.intertekFileName = intertekFileName;
        this.outputFileName = outputFileName;
    }

    public void parse() {
        this.readIntertekFile();
        File genotypeFile = new File(this.genotypeFileName);
        if (!genotypeFile.exists()) {
            System.out.println("Genotype file does not exist");
            System.exit(1);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(genotypeFile));
             PrintWriter writer = new PrintWriter(new FileWriter(new File(this.outputFileName)));){
            String str = reader.readLine();
            while (str.length() == 0 || str.startsWith("#")) {
                writer.println(str);
                str = reader.readLine();
            }
            this.genotypeMarkers = new HashSet();
            String[] markerNames = str.split("\t");
            for (int i = 1; i < markerNames.length; ++i) {
                this.genotypeMarkers.add(markerNames[i]);
            }
            writer.println(str);
            while ((str = reader.readLine()) != null) {
                writer.println(str);
            }
            for (String markerName : this.intertekMarkers.keySet()) {
                if (!this.genotypeMarkers.contains(markerName)) continue;
                IntertekMarker intertekMarker = this.intertekMarkers.get(markerName);
                writer.println("# fjFavAllele\t" + intertekMarker.getName() + "\t" + intertekMarker.getFavourableAlleles().stream().collect(Collectors.joining("\t")));
                writer.println("# fjUnfavAllele\t" + intertekMarker.getName() + "\t" + intertekMarker.getUnfavourableAlleles().stream().collect(Collectors.joining("\t")));
                if (intertekMarker.getAltName().isEmpty()) continue;
                writer.println("# fjAltMarkerName\t" + intertekMarker.getName() + "\t" + intertekMarker.getAltName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readIntertekFile() {
        File intertekFile = new File(this.intertekFileName);
        if (!intertekFile.exists()) {
            System.out.println("Intertek file does not exist");
            System.exit(1);
        }
        this.intertekMarkers = new HashMap<String, IntertekMarker>();
        try (BufferedReader reader = new BufferedReader(new FileReader(intertekFile));){
            String str = null;
            while ((str = reader.readLine()) != null) {
                if (str.toLowerCase().startsWith("intertek_snp_id")) continue;
                String[] tokens = str.split("\t");
                String markerName = tokens[0];
                String altName = tokens[1];
                String traitGene = tokens[2];
                String favourableAllele = tokens[3];
                String unfavourableAllele = tokens[4];
                this.intertekMarkers.put(markerName, new IntertekMarker(markerName, altName, traitGene, Collections.singletonList(favourableAllele), Collections.singletonList(unfavourableAllele)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Options mainOptions() {
        Options options = new Options();
        options.addRequiredOption("g", "genotype", true, "A filepath to a Flapjack formatted genotype file");
        options.addRequiredOption("i", "intertek", true, "A filepath to an Intertek formatted file with favourable allele information");
        options.addRequiredOption("o", "output", true, "A filepath to the name and location of the desired output file");
        return options;
    }

    private static void printHelp(String name) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(name, IntertekFavAlleleHeaderCreator.mainOptions(), true);
    }

    public class IntertekMarker {
        private String name;
        private String altName;
        private String traitGene;
        private List<String> favourableAlleles;
        private List<String> unfavourableAlleles;

        public IntertekMarker(String name, String altName, String traitGene, List<String> favourableAlleles, List<String> unfavourableAlleles) {
            this.name = name;
            this.altName = altName;
            this.traitGene = traitGene;
            this.favourableAlleles = favourableAlleles;
            this.unfavourableAlleles = unfavourableAlleles;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAltName() {
            return this.altName;
        }

        public void setAltName(String altName) {
            this.altName = altName;
        }

        public String getTraitGene() {
            return this.traitGene;
        }

        public void setTraitGene(String traitGene) {
            this.traitGene = traitGene;
        }

        public List<String> getFavourableAlleles() {
            return this.favourableAlleles;
        }

        public void setFavourableAlleles(List<String> favourableAlleles) {
            this.favourableAlleles = favourableAlleles;
        }

        public List<String> getUnfavourableAlleles() {
            return this.unfavourableAlleles;
        }

        public void setUnfavourableAlleles(List<String> unfavourableAlleles) {
            this.unfavourableAlleles = unfavourableAlleles;
        }
    }
}

