/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Color;
import java.text.DecimalFormat;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.table.LineDataTableModel;

public class TablePanelTableModel
extends LineDataTableModel {
    private final GTViewSet viewSet;
    private DecimalFormat df = new DecimalFormat("0.00");
    private int padIndex = -1;
    private int lineScoreIndex = -1;
    private int traitsOffset = -1;
    private int linkedOffset = -1;
    private int[] traitsModelCols;
    private int[] linkedModelCols;
    private LineDataTableModel traitsModel;
    private LineDataTableModel linkedModel;

    public TablePanelTableModel(GTViewSet viewSet) {
        this.viewSet = viewSet;
        int noCols = 1;
        this.columnNames = new String[noCols];
        this.columnNames[0] = "Line";
        if (viewSet != null) {
            int i;
            this.lines = viewSet.getLines();
            this.linkedModelCols = viewSet.getLinkedModelCols();
            this.traitsModelCols = viewSet.getTxtTraits();
            this.linkedModel = viewSet.tableHandler().model();
            this.traitsModel = Flapjack.winMain.getNavPanel().getTraitsPanel(viewSet.getDataSet(), false).getTraitsTab(false).getModel();
            if (viewSet.getDisplayLineScores() || this.traitsModelCols.length > 0 || this.linkedModelCols.length > 0) {
                this.padIndex = 1;
                ++noCols;
                if (viewSet.getDisplayLineScores()) {
                    this.lineScoreIndex = noCols++;
                }
                if (this.traitsModelCols.length > 0) {
                    this.traitsOffset = noCols;
                    noCols += this.traitsModelCols.length;
                }
                if (this.linkedModelCols.length > 0) {
                    this.linkedOffset = noCols;
                    noCols += this.linkedModelCols.length;
                }
            }
            this.columnNames = new String[noCols];
            this.columnNames[0] = "Line";
            if (this.padIndex != -1) {
                this.columnNames[1] = "";
            }
            if (this.lineScoreIndex != -1) {
                this.columnNames[this.lineScoreIndex] = "Sort score";
            }
            if (this.traitsOffset != -1) {
                for (i = 0; i < this.traitsModelCols.length; ++i) {
                    this.columnNames[i + this.traitsOffset] = viewSet.getDataSet().getTraits().get(i).getName();
                }
            }
            if (this.linkedOffset != -1) {
                for (i = 0; i < this.linkedModelCols.length; ++i) {
                    this.columnNames[i + this.linkedOffset] = viewSet.tableHandler().model().getColumnName(this.linkedModelCols[i]);
                }
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.viewSet == null ? 0 : this.lines.size();
    }

    @Override
    public Object getObjectAt(int row, int col) {
        LineInfo line = (LineInfo)this.lines.get(row);
        if (col == 0) {
            return line;
        }
        if (this.linkedOffset != -1 && col >= this.linkedOffset) {
            return this.linkedModel.getObjectForLine(line, this.linkedModelCols[col - this.linkedOffset]);
        }
        if (this.traitsOffset != -1 && col >= this.traitsOffset) {
            return line.getLine().getTraitValues().get(this.traitsModelCols[col - this.traitsOffset]).tableValue();
        }
        if (col == this.lineScoreIndex) {
            return this.df.format(((LineInfo)this.lines.get(row)).getScore());
        }
        return "";
    }

    @Override
    public Class<?> getObjectColumnClass(int col) {
        if (col == 0) {
            return LineInfo.class;
        }
        if (this.linkedOffset != -1 && col >= this.linkedOffset) {
            return this.linkedModel.getObjectColumnClass(this.linkedModelCols[col - this.linkedOffset]);
        }
        if (this.traitsOffset != -1 && col >= this.traitsOffset) {
            return this.traitsModel.getColumnClass(this.traitsModelCols[col - this.traitsOffset]);
        }
        if (col == this.lineScoreIndex) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public Color getDisplayColor(int row, int col) {
        if (col == 0) {
            return null;
        }
        if (this.linkedOffset != -1 && col >= this.linkedOffset) {
            return this.linkedModel.getDisplayColor(row, this.linkedModelCols[col - this.linkedOffset]);
        }
        if (this.traitsOffset != -1 && col >= this.traitsOffset) {
            return this.traitsModel.getDisplayColor(row, this.traitsModelCols[col - this.traitsOffset]);
        }
        return null;
    }
}

