/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.data.Cookie;
import org.restlet.engine.util.SystemUtils;

public final class CookieSetting
extends Cookie {
    private volatile boolean accessRestricted;
    private volatile String comment;
    private volatile int maxAge;
    private volatile boolean secure;

    public CookieSetting() {
        this(0, null, null);
    }

    public CookieSetting(int version, String name, String value) {
        this(version, name, value, null, null);
    }

    public CookieSetting(int version, String name, String value, String path, String domain) {
        this(version, name, value, path, domain, null, -1, false, false);
    }

    public CookieSetting(int version, String name, String value, String path, String domain, String comment, int maxAge, boolean secure) {
        this(version, name, value, path, domain, comment, maxAge, secure, false);
    }

    public CookieSetting(int version, String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean accessRestricted) {
        super(version, name, value, path, domain);
        this.comment = comment;
        this.maxAge = maxAge;
        this.secure = secure;
        this.accessRestricted = accessRestricted;
    }

    public CookieSetting(String name, String value) {
        this(0, name, value, null, null);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && super.equals(obj) && obj instanceof CookieSetting) {
            CookieSetting that = (CookieSetting)obj;
            boolean bl2 = result = this.maxAge == that.maxAge && this.secure == that.secure;
            if (result) {
                result = this.comment != null ? this.comment.equals(that.comment) : that.comment == null;
            }
        }
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDescription() {
        return "Cookie setting";
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(super.hashCode(), this.getComment(), this.getMaxAge(), this.isSecure());
    }

    public boolean isAccessRestricted() {
        return this.accessRestricted;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setAccessRestricted(boolean accessRestricted) {
        this.accessRestricted = accessRestricted;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public String toString() {
        return "CookieSetting [accessRestricted=" + this.accessRestricted + ", comment=" + this.comment + ", maxAge=" + this.maxAge + ", secure=" + this.secure + ", domain=" + this.getDomain() + ", name=" + this.getName() + ", path=" + this.getPath() + ", value=" + this.getValue() + ", version=" + this.getVersion() + "]";
    }
}

