/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HapMapToFJTabbedConverter {
    private static final String HAPMAP_HEADER_ID = "rs";
    private File hapMap;
    private File map;
    private File genotypes;
    private List<Marker> markers;
    private Line[] lines;
    private String separator;
    private static final String TAB_SEPARATOR = "\t";
    private static final String SPACE_SEPARATOR = "\\s+";

    public static void main(String[] args) {
        HapMapToFJTabbedConverter toFlapjack = new HapMapToFJTabbedConverter(args);
        toFlapjack.convert();
        System.exit(0);
    }

    private HapMapToFJTabbedConverter(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-genotypes=")) {
                this.genotypes = new File(arg.substring(11));
            }
            if (arg.startsWith("-separator=")) {
                this.separator = arg.substring(11);
            }
            if (arg.startsWith("-map=")) {
                this.map = new File(arg.substring(5));
            }
            if (!arg.startsWith("-hapmap=")) continue;
            this.hapMap = new File(arg.substring(8));
        }
        if (this.genotypes == null || this.map == null || this.hapMap == null || this.separator == null || this.separator != null && !this.separator.equals("s") && !this.separator.equals("t")) {
            HapMapToFJTabbedConverter.printHelp();
        }
        if (this.separator.equals("s")) {
            this.separator = SPACE_SEPARATOR;
        } else if (this.separator.equals("t")) {
            this.separator = TAB_SEPARATOR;
        }
    }

    public HapMapToFJTabbedConverter(File hapMap, File map, File genoytpyes, String separator) {
        this.hapMap = hapMap;
        this.map = map;
        this.genotypes = genoytpyes;
        this.separator = separator;
    }

    public void convert() {
        this.processHapMapFile();
        this.outputMapFile();
        this.outputGenotypeFile();
    }

    private void processHapMapFile() {
        System.out.println("Reading HapMap file");
        this.markers = new ArrayList<Marker>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.hapMap));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] cols = line.split(this.separator);
                String[] genos = Arrays.copyOfRange(cols, 11, cols.length);
                if (line.startsWith(HAPMAP_HEADER_ID)) {
                    this.processHeaderLine(genos);
                } else {
                    this.createMarker(cols[0], cols[2], cols[3]);
                    this.addSnpCallsToLines(genos);
                }
                if (++i % 100 != 0) continue;
                System.out.println("Processed: " + i + " lines");
            }
            System.out.println("Finished reading HapMap file");
            System.out.println("Total lines processed = " + i);
            System.out.println("Found " + this.markers.size() + " markers and " + this.lines.length + " accessions / lines");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void processHeaderLine(String[] lineNames) {
        this.lines = new Line[lineNames.length];
        for (int i = 0; i < lineNames.length; ++i) {
            this.lines[i] = new Line(lineNames[i]);
        }
    }

    private void createMarker(String name, String chromosome, String position) {
        Marker marker = new Marker(name, chromosome, position);
        this.markers.add(marker);
    }

    private void addSnpCallsToLines(String[] snpCalls) {
        for (int i = 0; i < snpCalls.length; ++i) {
            this.lines[i].addSnpCall(this.convertAndCollapseSnpCall(snpCalls[i]));
        }
    }

    private String convertAndCollapseSnpCall(String call) {
        if (call.length() == 1) {
            String converted;
            switch (call) {
                case "A": {
                    converted = "A";
                    break;
                }
                case "G": {
                    converted = "G";
                    break;
                }
                case "C": {
                    converted = "C";
                    break;
                }
                case "T": {
                    converted = "T";
                    break;
                }
                case "Y": {
                    converted = "C/T";
                    break;
                }
                case "R": {
                    converted = "A/G";
                    break;
                }
                case "W": {
                    converted = "A/T";
                    break;
                }
                case "S": {
                    converted = "G/C";
                    break;
                }
                case "K": {
                    converted = "T/G";
                    break;
                }
                case "M": {
                    converted = "C/A";
                    break;
                }
                default: {
                    converted = "N";
                }
            }
            return converted;
        }
        String converted = call.charAt(0) == call.charAt(1) ? (call.substring(0, 1).equals("N") ? "-" : call.substring(0, 1)) : call.substring(0, 1) + "/" + call.substring(1, 2);
        return converted;
    }

    private void outputMapFile() {
        System.out.println();
        System.out.println("Outputting map file: " + this.map.getAbsolutePath());
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.map)));){
            writer.println("# fjFile = MAP");
            this.markers.forEach(marker -> writer.println(marker.name() + TAB_SEPARATOR + marker.chromosome() + TAB_SEPARATOR + marker.position()));
            System.out.println("Finished outputting map file: " + this.map.getAbsolutePath());
            System.out.println("Wrote " + this.markers.size() + " markers to file");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void outputGenotypeFile() {
        System.out.println();
        System.out.println("Outputting genotype file: " + this.genotypes.getAbsolutePath());
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.genotypes)));){
            writer.println("# fjFile = GENOTYPE");
            this.markers.forEach(marker -> writer.print(TAB_SEPARATOR + marker.name()));
            writer.println();
            Stream.of(this.lines).forEach(line -> writer.println(line.name() + TAB_SEPARATOR + line.snpCalls().stream().collect(Collectors.joining(TAB_SEPARATOR))));
            System.out.println("Finished outputting genotype file: " + this.genotypes.getAbsolutePath());
            System.out.println("Wrote " + this.lines.length + " accessions / lines to file");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage: hapmap2flapjack <options>\n where valid options are:\n   -separator=<s or t>            (required separator used in input file)\n   -hapmap=<hapmap_file>          (required input file)\n   -map=<map_file>                (required output file)\n   -genotypes=<genotype_file>     (required output file)\n");
        System.exit(1);
    }

    class Line {
        private String name;
        private List<String> snpCalls;

        public Line(String name) {
            this.name = name;
            this.snpCalls = new ArrayList<String>();
        }

        public void addSnpCall(String call) {
            this.snpCalls.add(call);
        }

        public String name() {
            return this.name;
        }

        public List<String> snpCalls() {
            return this.snpCalls;
        }
    }

    class Marker {
        private String name;
        private String chromosome;
        private String position;

        public Marker(String name, String chromosome, String position) {
            this.name = name;
            this.chromosome = chromosome;
            this.position = position;
        }

        public String name() {
            return this.name;
        }

        public String chromosome() {
            return this.chromosome;
        }

        public String position() {
            return this.position;
        }
    }
}

