/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GraphData;
import jhi.flapjack.data.Marker;
import jhi.flapjack.io.MarkerIndex;
import scri.commons.gui.SimpleJob;
import scri.commons.io.ProgressInputStream;

public class GraphImporter
extends SimpleJob {
    protected NumberFormat nf = NumberFormat.getInstance();
    protected String SIG = "SIGNIFICANCE_THRESHOLD";
    protected ProgressInputStream is;
    protected File file;
    protected DataSet dataSet;
    protected BufferedReader in;
    protected String str;
    protected HashMap<String, MarkerList> markers = new HashMap();
    protected HashMap<String, Float> names = new HashMap();
    protected HashMap<String, GraphData> graphs = new HashMap();

    public GraphImporter(File file, DataSet dataSet) {
        this.file = file;
        this.dataSet = dataSet;
        this.maximum = 5555;
    }

    public void runJob(int index) throws Exception {
        this.setupForParse();
        this.parseFile();
        this.in.close();
        if (this.okToRun) {
            this.normalize();
        } else {
            for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
                map.getGraphs().clear();
            }
        }
    }

    protected void parseFile() throws Exception {
        while ((this.str = this.in.readLine()) != null && this.okToRun) {
            if (this.str.length() == 0 || this.str.startsWith("#")) continue;
            String[] tokens = this.str.trim().split("\t", -1);
            String marker = tokens[0];
            String graphName = tokens[1];
            float value = this.nf.parse(tokens[2]).floatValue();
            this.addToGraph(marker, graphName, value);
        }
    }

    protected void setupForParse() throws Exception, FileNotFoundException {
        for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
            map.getGraphs().clear();
        }
        this.buildMarkerHash();
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        this.in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        this.str = null;
    }

    protected void addToGraph(String marker, String graphName, float value) throws ArrayIndexOutOfBoundsException {
        MarkerList mList = this.markers.get(marker);
        if (mList == null && !marker.equalsIgnoreCase(this.SIG)) {
            return;
        }
        if (this.names.get(graphName) == null) {
            for (int i = 0; i < this.dataSet.getChromosomeMaps().size(); ++i) {
                ChromosomeMap map = this.dataSet.getMapByIndex(i);
                GraphData graph = new GraphData(map, graphName);
                this.graphs.put(i + "_" + graphName, graph);
                map.getGraphs().add(graph);
            }
            this.names.put(graphName, Float.valueOf(Float.MIN_VALUE));
        }
        if (mList != null) {
            for (MarkerIndex mIndex : mList.markers) {
                String gIndex = mIndex.mapIndex + "_" + graphName;
                GraphData graph = this.graphs.get(gIndex);
                graph.setValue(mIndex.mkrIndex, value);
            }
        } else {
            this.names.put(graphName, Float.valueOf(value));
        }
    }

    protected void normalize() throws Exception {
        for (int i = 0; i < this.names.size(); ++i) {
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
                map.getGraphs().get(i).determineLimits();
                min = Math.min(map.getGraphs().get(i).getMinimum(), min);
                max = Math.max(map.getGraphs().get(i).getMaximum(), max);
            }
            for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
                map.getGraphs().get(i).setMinimum(min);
                map.getGraphs().get(i).setMaximum(max);
            }
        }
        for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
            for (GraphData graph : map.getGraphs()) {
                if (this.names.get(graph.getName()).floatValue() != Float.MIN_VALUE) {
                    graph.setThreshold(this.names.get(graph.getName()).floatValue());
                    graph.setHasThreshold(true);
                }
                graph.normalize();
            }
        }
    }

    private void buildMarkerHash() throws Exception {
        long s = System.currentTimeMillis();
        int mapIndex = 0;
        for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
            int mrkIndex = 0;
            for (Marker marker : map.getMarkers()) {
                MarkerIndex mi = new MarkerIndex(mapIndex, mrkIndex++);
                if (this.markers.containsKey(marker.getName())) {
                    this.markers.get(marker.getName()).add(mi);
                    continue;
                }
                this.markers.put(marker.getName(), new MarkerList(mi));
            }
            ++mapIndex;
        }
        long e = System.currentTimeMillis();
        System.out.println("Marker index build in " + (e - s) + "ms");
    }

    public int getValue() {
        if (this.is == null) {
            return 0;
        }
        return Math.round((float)this.is.getBytesRead() / (float)this.file.length() * 5555.0f);
    }

    private static class MarkerList {
        ArrayList<MarkerIndex> markers = new ArrayList();

        MarkerList(MarkerIndex mi) {
            this.add(mi);
        }

        void add(MarkerIndex mi) {
            this.markers.add(mi);
        }
    }
}

