/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.StateTable;
import scri.commons.gui.SimpleJob;

public class SimulateF1
extends SimpleJob {
    private GTViewSet viewSet;
    private int p1Index;
    private int p2Index;
    private int f1Index;

    public SimulateF1(GTViewSet viewSet, int p1Index, int p2Index) {
        this.viewSet = viewSet;
        this.p1Index = p1Index;
        this.p2Index = p2Index;
    }

    public void runJob(int i) throws Exception {
        AnalysisSet as = new AnalysisSet(this.viewSet).withViews(null).withSelectedLines().withAllMarkersIncludingHidden();
        this.simulate(as);
    }

    private void simulate(AnalysisSet as) {
        String f1Name = "Exp F1:" + as.getLines().get(this.p1Index).name() + "x" + as.getLines().get(this.p2Index).name();
        Line f1 = this.viewSet.getDataSet().createLine(f1Name, true);
        StateTable stateTable = this.viewSet.getDataSet().getStateTable();
        for (int c = 0; c < as.viewCount(); ++c) {
            if (!as.getGTView(c).getChromosomeMap().isSpecialChromosome()) {
                for (int m = 0; m < as.markerCount(c); ++m) {
                    int p1State = as.getState(c, this.p1Index, m);
                    int p2State = as.getState(c, this.p2Index, m);
                    this.setLociForF1(f1, stateTable, c, m, p1State, p2State);
                }
                continue;
            }
            int specialChromsomeIndex = c;
            int loci = 0;
            int dummyCount = 5;
            for (int view = 0; view < as.viewCount() - 1; ++view) {
                int m = 0;
                while (m < as.markerCount(view)) {
                    int p1State = as.getState(view, this.p1Index, m);
                    int p2State = as.getState(view, this.p2Index, m);
                    this.setLociForF1(f1, stateTable, c, loci, p1State, p2State);
                    ++m;
                    ++loci;
                }
                if (view >= specialChromsomeIndex - 1) continue;
                int d = 0;
                while (d < dummyCount) {
                    f1.setLoci(c, loci, 0);
                    ++d;
                    ++loci;
                }
            }
        }
        this.viewSet.getLines().add(new LineInfo(f1, this.viewSet.getDataSet().countLines()));
        this.f1Index = this.viewSet.getLines().size() - 1;
    }

    private void setLociForF1(Line f1, StateTable stateTable, int c, int m, int p1State, int p2State) {
        if (stateTable.isHet(p1State) || stateTable.isHet(p2State) || p1State == 0 || p2State == 0) {
            f1.setLoci(c, m, 0);
        } else if (p1State == p2State) {
            f1.setLoci(c, m, p1State);
        } else {
            int codeForHet = this.findCodeForHet(stateTable, p1State, p2State);
            f1.setLoci(c, m, codeForHet);
        }
    }

    private int findCodeForHet(StateTable stateTable, int p1StateCode, int p2StateCode) {
        int codeForHet = -1;
        String p1Allele = stateTable.getAlleleState(p1StateCode).homzAllele();
        String p2Allele = stateTable.getAlleleState(p2StateCode).homzAllele();
        AlleleState f1State = new AlleleState(p1Allele + "/" + p2Allele, true, "/");
        for (int i = 0; i < stateTable.getStates().size(); ++i) {
            if (!f1State.matches(stateTable.getAlleleState(i))) continue;
            codeForHet = i;
            break;
        }
        if (codeForHet == -1) {
            codeForHet = stateTable.getStateCode(p1Allele + "/" + p2Allele, true, " ", true, "/");
        }
        return codeForHet;
    }

    public int getF1Index() {
        return this.f1Index;
    }
}

