/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jhi.flapjack.analysis.FindLine;
import jhi.flapjack.analysis.FindMarker;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.analysis.FindPanelNB;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.LMHighlighter;
import scri.commons.gui.RB;
import scri.commons.gui.SwingUtils;
import scri.commons.gui.TaskDialog;

public class FindDialog
extends JDialog
implements ListSelectionListener {
    private FindPanelNB nbPanel = new FindPanelNB(this);
    private GenotypePanel gPanel;
    private Finder finder = new Finder();
    private DecimalFormat d = new DecimalFormat("0.0");
    private GTViewSet viewSet;
    private LMHighlighter lmHighlighter;

    public FindDialog(JFrame parent, GenotypePanel gPanel) {
        super(parent, RB.getString((String)"gui.dialog.FindDialog.title"), false);
        this.gPanel = gPanel;
        this.add(this.nbPanel);
        this.addListeners();
        this.getRootPane().setDefaultButton(this.nbPanel.bSearch);
        SwingUtils.addCloseHandler((Window)this, (JComponent)this.nbPanel);
        this.setTableModel(null);
        this.pack();
        this.setResizable(false);
        SwingUtils.positionWindow((Window)this, null, (int)Prefs.guiFindDialogX, (int)Prefs.guiFindDialogY);
    }

    private void addListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Prefs.guiFindDialogX = FindDialog.this.getLocation().x;
                Prefs.guiFindDialogY = FindDialog.this.getLocation().y;
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (FindDialog.this.gPanel.getViewSet() != FindDialog.this.viewSet) {
                    FindDialog.this.setTableModel(null);
                }
            }
        });
        this.nbPanel.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FindDialog.this.processTableSelection();
            }
        });
    }

    void setTableModel(Object[][] data) {
        Object[] columnNames = Prefs.guiFindMethod == 0 ? new String[]{RB.getString((String)"gui.dialog.NBFindPanel.colLineName")} : new String[]{RB.getString((String)"gui.dialog.NBFindPanel.colMarkerName"), RB.getString((String)"gui.dialog.NBFindPanel.colChromosome"), RB.getString((String)"gui.dialog.NBFindPanel.colPosition")};
        if (data == null) {
            this.nbPanel.tableModel = new DefaultTableModel(columnNames, 0){

                @Override
                public boolean isCellEditable(int rowIndex, int mColIndex) {
                    return false;
                }
            };
            this.nbPanel.resultLabel.setText(RB.format((String)"gui.dialog.NBFindPanel.resultLabel2", (Object[])new Object[]{0}));
        } else {
            this.nbPanel.tableModel = new DefaultTableModel(data, columnNames){

                @Override
                public boolean isCellEditable(int rowIndex, int mColIndex) {
                    return false;
                }
            };
            if (data.length == 1) {
                this.nbPanel.resultLabel.setText(RB.getString((String)"gui.dialog.NBFindPanel.resultLabel1"));
            } else {
                this.nbPanel.resultLabel.setText(RB.format((String)"gui.dialog.NBFindPanel.resultLabel2", (Object[])new Object[]{data.length}));
            }
        }
        this.nbPanel.table.setModel(this.nbPanel.tableModel);
        this.nbPanel.table.setCellEditor(null);
    }

    void runSearch() {
        new Thread(this.finder).start();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || this.nbPanel.table.getSelectedRow() == -1) {
            return;
        }
        this.processTableSelection();
    }

    void processTableSelection() {
        int row = this.nbPanel.table.getSelectedRow();
        if (row != -1) {
            Object selected = this.nbPanel.tableModel.getValueAt(row, 0);
            if (selected instanceof LineInfo) {
                this.displayLine((LineInfo)selected);
            } else if (selected instanceof Marker) {
                Object map = this.nbPanel.tableModel.getValueAt(row, 1);
                this.displayMarker((Marker)selected, (ChromosomeMap)map);
            }
        }
    }

    private void displayLine(LineInfo lineInfo) {
        int lineIndex = this.viewSet.indexOf(lineInfo);
        this.jumpToPosition(lineIndex, -1);
        this.lmHighlighter = new LMHighlighter(this.gPanel, lineIndex, this.lmHighlighter, 0);
    }

    private void displayMarker(Marker marker, ChromosomeMap map) {
        GTView view = this.viewSet.getView(map);
        int viewIndex = this.viewSet.indexof(view);
        int markerIndex = view.indexOf(marker);
        if (this.gPanel.getView() != view) {
            this.viewSet.setViewIndex(viewIndex);
            this.gPanel.setViewSet(this.viewSet);
        }
        this.jumpToPosition(-1, markerIndex);
        this.lmHighlighter = new LMHighlighter(this.gPanel, markerIndex, this.lmHighlighter, 1);
    }

    private void jumpToPosition(int lineIndex, int markerIndex) {
        this.gPanel.moveToPosition(lineIndex, markerIndex, true);
    }

    private class Finder
    implements Runnable {
        FindLine lineFinder;
        FindMarker markerFinder;

        private Finder() {
        }

        @Override
        public void run() {
            if (Prefs.guiFindUseRegex) {
                try {
                    Pattern.compile(FindDialog.this.nbPanel.getSearchStr());
                }
                catch (PatternSyntaxException e) {
                    TaskDialog.error((String)RB.format((String)"gui.dialog.FindDialog.regexError", (Object[])new Object[]{e.getMessage()}), (String)RB.getString((String)"gui.text.close"));
                    return;
                }
            }
            try {
                FindDialog.this.viewSet = FindDialog.this.gPanel.getViewSet();
                if (Prefs.guiFindMethod == 0) {
                    this.lineFinder = new FindLine(FindDialog.this.gPanel.getView(), Prefs.guiFindMatchCase, Prefs.guiFindUseRegex);
                    this.findLine();
                } else {
                    boolean allChromosomes = Prefs.guiFindMethod == 2;
                    this.markerFinder = new FindMarker(FindDialog.this.gPanel.getViewSet(), allChromosomes, Prefs.guiFindMatchCase, Prefs.guiFindUseRegex);
                    this.findMarker();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void findLine() {
            LinkedList<FindLine.Result> results = this.lineFinder.search(FindDialog.this.nbPanel.getSearchStr());
            Object[][] data = new Object[results.size()][1];
            int i = 0;
            for (FindLine.Result result : results) {
                data[i++][0] = result.line;
            }
            this.updateTable(data);
        }

        private void findMarker() {
            LinkedList<FindMarker.Result> results = this.markerFinder.search(FindDialog.this.nbPanel.getSearchStr());
            Object[][] data = new Object[results.size()][3];
            int i = 0;
            for (FindMarker.Result result : results) {
                data[i][0] = result.marker;
                data[i][1] = result.map;
                data[i][2] = FindDialog.this.d.format(result.marker.getRealPosition());
                ++i;
            }
            this.updateTable(data);
        }

        private void updateTable(Object[][] data) {
            Runnable r = () -> FindDialog.this.setTableModel(data);
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

