/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;

public class DefaultShadowGenerator
implements ShadowGenerator,
Serializable {
    private static final long serialVersionUID = 2732993885591386064L;
    private int shadowSize;
    private Color shadowColor;
    private float shadowOpacity;
    private double angle;
    private int distance;

    public DefaultShadowGenerator() {
        this(5, Color.black, 0.5f, 5, -0.7853981633974483);
    }

    public DefaultShadowGenerator(int size, Color color, float opacity, int distance, double angle) {
        ParamChecks.nullNotPermitted(color, "color");
        this.shadowSize = size;
        this.shadowColor = color;
        this.shadowOpacity = opacity;
        this.distance = distance;
        this.angle = angle;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getDistance() {
        return this.distance;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public int calculateOffsetX() {
        return (int)(Math.cos(this.angle) * (double)this.distance) - this.shadowSize;
    }

    @Override
    public int calculateOffsetY() {
        return -((int)(Math.sin(this.angle) * (double)this.distance)) - this.shadowSize;
    }

    @Override
    public BufferedImage createDropShadow(BufferedImage source) {
        BufferedImage subject = new BufferedImage(source.getWidth() + this.shadowSize * 2, source.getHeight() + this.shadowSize * 2, 2);
        Graphics2D g2 = subject.createGraphics();
        g2.drawImage(source, null, this.shadowSize, this.shadowSize);
        g2.dispose();
        this.applyShadow(subject);
        return subject;
    }

    protected void applyShadow(BufferedImage image) {
        int a;
        int historyIdx;
        int aSum;
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = this.shadowSize - 1 >> 1;
        int right = this.shadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        int shadowRgb = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[this.shadowSize];
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = this.shadowOpacity / (float)this.shadowSize;
        int y = 0;
        int bufferOffset = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < this.shadowSize) {
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= this.shadowSize) {
                    historyIdx -= this.shadowSize;
                }
                ++x;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        int x = 0;
        bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < this.shadowSize) {
                aHistory[y2] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= this.shadowSize) {
                    historyIdx -= this.shadowSize;
                }
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultShadowGenerator)) {
            return false;
        }
        DefaultShadowGenerator that = (DefaultShadowGenerator)obj;
        if (this.shadowSize != that.shadowSize) {
            return false;
        }
        if (!this.shadowColor.equals(that.shadowColor)) {
            return false;
        }
        if (this.shadowOpacity != that.shadowOpacity) {
            return false;
        }
        if (this.distance != that.distance) {
            return false;
        }
        return this.angle == that.angle;
    }

    public int hashCode() {
        int hash = HashUtilities.hashCode(17, this.shadowSize);
        hash = HashUtilities.hashCode(hash, this.shadowColor);
        hash = HashUtilities.hashCode(hash, this.shadowOpacity);
        hash = HashUtilities.hashCode(hash, this.distance);
        hash = HashUtilities.hashCode(hash, this.angle);
        return hash;
    }
}

