/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet;

import java.io.File;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import jhi.flapjack.servlet.api.IScheduler;
import jhi.flapjack.servlet.api.SLURMScheduler;
import jhi.flapjack.servlet.dendrogram.DendrogramServerResource;
import jhi.flapjack.servlet.pcoa.PCoAServerResource;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;

public class FlapjackServlet
extends Application
implements ServletContextListener {
    public static Logger LOG;
    private static IScheduler scheduler;
    public static String rPath;
    public static String fjPath;

    public FlapjackServlet() {
        this.setName("Flapjack");
        this.setDescription("Flapjack Web Services");
        this.setOwner("The James Hutton Institute");
        this.setAuthor("Information & Computational Sciences, JHI");
        LOG = Logger.getLogger(FlapjackServlet.class.getName());
    }

    public void start() throws Exception {
        super.start();
        rPath = this.getContext().getParameters().getFirstValue("r.path");
        ServletContext sc = (ServletContext)this.getContext().getAttributes().get("org.restlet.ext.servlet.ServletContext");
        fjPath = sc.getRealPath("/WEB-INF/lib/flapjack.jar");
    }

    public void contextInitialized(ServletContextEvent arg0) {
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        try {
            scheduler.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attach("/pcoa", PCoAServerResource.class);
        router.attach("/pcoa/", PCoAServerResource.class);
        router.attach("/pcoa/{id}", PCoAServerResource.class);
        router.attach("/dendrogram", DendrogramServerResource.class);
        router.attach("/dendrogram/", DendrogramServerResource.class);
        router.attach("/dendrogram/{id}", DendrogramServerResource.class);
        return router;
    }

    public static File getWorkingDir(String taskId) {
        File tmpdir = new File(System.getProperty("java.io.tmpdir"), "flapjack");
        File wrkdir = new File(tmpdir, taskId);
        wrkdir.mkdirs();
        return wrkdir;
    }

    public static IScheduler getScheduler() {
        return scheduler;
    }

    static {
        scheduler = new SLURMScheduler();
        rPath = "/usr/bin/R";
    }
}

