/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.Timer;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.RB;
import scri.commons.gui.SystemUtils;

public class WinMainStatusBar
extends JPanel {
    private JLabel tipsLabel;
    private JLabel helpLabel;
    private ArrayList<String> helpHints = new ArrayList();
    private JLabel threadLabel;
    private int cores = Runtime.getRuntime().availableProcessors();
    private DecimalFormat df = new DecimalFormat("0.00");
    private MemoryMXBean mBean = ManagementFactory.getMemoryMXBean();
    private ThreadMXBean tBean = ManagementFactory.getThreadMXBean();
    int bgColor = new JPanel().getBackground().getRed();

    WinMainStatusBar(final GenotypePanel panel) {
        for (int i = 1; i < 1000 && RB.exists((String)("gui.StatusBar.help" + i)); ++i) {
            if (SystemUtils.isMacOS()) {
                this.helpHints.add(RB.format((String)("gui.StatusBar.help" + i), (Object[])new Object[]{RB.getString((String)"gui.StatusBar.cmnd")}));
                continue;
            }
            this.helpHints.add(RB.format((String)("gui.StatusBar.help" + i), (Object[])new Object[]{RB.getString((String)"gui.StatusBar.ctrl")}));
        }
        this.tipsLabel = new JLabel(RB.getString((String)"gui.StatusBar.helpText"));
        this.helpLabel = new JLabel();
        JPanel helpPanel = new JPanel(new FlowLayout(0, 5, 2));
        helpPanel.add(this.tipsLabel);
        helpPanel.add(this.helpLabel);
        this.threadLabel = new JLabel();
        JPanel renderPanel = new JPanel(new FlowLayout(2, 5, 2));
        renderPanel.add(this.threadLabel);
        Color lineColor = new JMenuBar().getBackground();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, lineColor), BorderFactory.createEmptyBorder(1, 2, 2, 2)));
        this.add((Component)helpPanel, "West");
        this.add((Component)renderPanel, "East");
        Timer tipsTimer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TipsThread().start();
            }
        });
        tipsTimer.setInitialDelay(0);
        tipsTimer.start();
        Timer threadsTimer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long used = WinMainStatusBar.this.mBean.getHeapMemoryUsage().getUsed() + WinMainStatusBar.this.mBean.getNonHeapMemoryUsage().getUsed();
                int t = WinMainStatusBar.this.tBean.getThreadCount() - WinMainStatusBar.this.tBean.getDaemonThreadCount();
                String canvas = panel.getStatusSummary();
                WinMainStatusBar.this.threadLabel.setText(canvas + ", " + WinMainStatusBar.this.cores + "C, " + t + "T, " + WinMainStatusBar.this.df.format((float)used / 1024.0f / 1024.0f) + "MB");
            }
        });
        threadsTimer.setInitialDelay(0);
        threadsTimer.start();
    }

    private class TipsThread
    extends Thread {
        private TipsThread() {
        }

        @Override
        public void run() {
            float step = (float)WinMainStatusBar.this.bgColor / 15.0f;
            float fontColor = 0.0f;
            for (int i = 0; i < 16 || fontColor < (float)WinMainStatusBar.this.bgColor; ++i) {
                int c = (int)fontColor;
                WinMainStatusBar.this.helpLabel.setForeground(new Color(c, c, c));
                fontColor += step;
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception i) {
                // empty catch block
            }
            int index = new Random().nextInt(WinMainStatusBar.this.helpHints.size());
            WinMainStatusBar.this.helpLabel.setText((String)WinMainStatusBar.this.helpHints.get(index));
            fontColor = WinMainStatusBar.this.bgColor;
            for (int i = 0; i < 16 || fontColor > 0.0f; ++i) {
                int c = (int)fontColor;
                WinMainStatusBar.this.helpLabel.setForeground(new Color(c, c, c));
                fontColor -= step;
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

