/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.table.SortColumn;
import jhi.flapjack.gui.table.SortDialogTableModel;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;

public class SortDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private boolean isOK = false;
    private SortDialogTableModel model;
    private JButton bAdd;
    private JButton bCancel;
    private JButton bDelete;
    private JButton bHelp;
    private JButton bSort;
    private DialogPanel dialogPanel1;
    private JScrollPane jScrollPane1;
    private JTable table;

    public SortDialog(SortColumn[] allCols, SortColumn[] lastUsedCols) {
        super(Flapjack.winMain, RB.getString((String)"gui.table.SortDialog.title"), true);
        this.initComponents();
        this.initTable(allCols, lastUsedCols);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        RB.setText((AbstractButton)this.bSort, (String)"gui.table.SortDialog.bSort");
        RB.setText((AbstractButton)this.bAdd, (String)"gui.table.SortDialog.bAdd");
        RB.setText((AbstractButton)this.bDelete, (String)"gui.table.SortDialog.bDelete");
        this.bSort.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bAdd.addActionListener(this);
        this.bDelete.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "_-_Analysis_Results_Tables");
        this.checkButtonStates();
        FlapjackUtils.initDialog(this, this.bSort, this.bCancel, true, this.getContentPane());
    }

    private void initTable(SortColumn[] allCols, SortColumn[] lastUsedCols) {
        this.model = new SortDialogTableModel(allCols, lastUsedCols);
        this.table.setModel(this.model);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.model.getColumnNameComboBox()));
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.model.getSortOrderComboBox()));
        this.table.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bAdd) {
            this.model.addRow();
        } else if (e.getSource() == this.bDelete) {
            this.model.deleteRow(this.table.getSelectedRow());
        }
        this.checkButtonStates();
        if (e.getSource() == this.bSort) {
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    public SortColumn[] getResults() {
        return this.model.getResults();
    }

    private void checkButtonStates() {
        this.bAdd.setEnabled(this.model.getRowCount() > 0);
        if (this.model.getRowCount() > 1 && this.table.getSelectedRow() != -1) {
            this.bDelete.setEnabled(true);
        } else {
            this.bDelete.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.checkButtonStates();
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bSort = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.bAdd = new JButton();
        this.bDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.bSort.setText("Sort");
        this.dialogPanel1.add((Component)this.bSort);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView(this.table);
        this.bAdd.setText("Add sort level");
        this.bDelete.setText("Delete sort level");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDelete).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bAdd).addComponent(this.bDelete)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 174, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, 46, -2)));
        this.pack();
    }
}

