/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.pedver;

import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.results.PedVerLinesResult;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.table.LineDataTableModel;

class PedVerLinesTableModel
extends LineDataTableModel {
    private GTViewSet viewSet;
    private int selectedIndex;
    private int commentsIndex;
    private int sortIndex;

    PedVerLinesTableModel(DataSet dataSet, GTViewSet viewSet) {
        this.dataSet = dataSet;
        this.viewSet = viewSet;
        this.setLines(viewSet.tableHandler().linesForTable());
        this.initModel();
    }

    void initModel() {
        PedVerLinesResult stats = ((LineInfo)this.lines.get(0)).getResults().getPedVerLinesResult();
        this.columnNames = new String[10 + stats.getChrMatchCount().size()];
        this.selectedIndex = this.columnNames.length - 3;
        this.commentsIndex = this.columnNames.length - 2;
        this.sortIndex = this.columnNames.length - 1;
        this.columnNames[0] = "Line";
        this.columnNames[1] = "Marker count";
        this.columnNames[2] = "% Missing";
        this.columnNames[3] = "Het Count";
        this.columnNames[4] = "% Het";
        this.columnNames[5] = "Match Count";
        this.columnNames[6] = "% Match";
        for (int i = 0; i < stats.getChrMatchCount().size(); ++i) {
            this.columnNames[i + 7] = "Match in " + this.viewSet.getView(i).getChromosomeMap().getName();
        }
        this.columnNames[this.selectedIndex] = "Selected";
        this.columnNames[this.commentsIndex] = "Comments";
        this.columnNames[this.sortIndex] = "Don't Sort/Filter";
    }

    @Override
    public boolean skipExport(int col) {
        return col == this.sortIndex;
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public Object getObjectAt(int row, int col) {
        LineInfo line = (LineInfo)this.lines.get(row);
        PedVerLinesResult stats = line.getResults().getPedVerLinesResult();
        if (col == 0) {
            return line;
        }
        if (col == this.selectedIndex) {
            return line.getSelected();
        }
        if (col == this.sortIndex) {
            return line.getResults().isSortToTop();
        }
        if (stats == null) {
            return null;
        }
        if (col == 1) {
            return stats.getMarkerCount();
        }
        if (col == 2) {
            return stats.getMissingPerc();
        }
        if (col == 3) {
            return stats.getHetCount();
        }
        if (col == 4) {
            return stats.getHetPerc();
        }
        if (col == 5) {
            return stats.getMatchCount();
        }
        if (col == 6) {
            return stats.getMatchPerc();
        }
        if (col >= 7 && col < this.commentsIndex) {
            return stats.getChrMatchCount().get(col - 7);
        }
        if (col == this.commentsIndex) {
            String comment = line.getResults().getComments();
            return comment == null ? "" : comment;
        }
        return null;
    }

    @Override
    public Class getObjectColumnClass(int col) {
        if (col == 0) {
            return LineInfo.class;
        }
        if (col == this.selectedIndex || col == this.sortIndex) {
            return Boolean.class;
        }
        if (col == this.commentsIndex) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == this.selectedIndex || col == this.commentsIndex || col == this.sortIndex;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        LineInfo line = (LineInfo)this.getObjectAt(row, 0);
        if (col == this.selectedIndex) {
            PedVerLinesTableModel.selectLine(line, (Boolean)value);
        } else if (col == this.commentsIndex) {
            line.getResults().setComments((String)value);
        } else if (col == this.sortIndex) {
            line.getResults().setSortToTop((Boolean)value);
        }
        this.fireTableRowsUpdated(row, row);
        Actions.projectModified();
    }
}

