/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.pedver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.TitlePanel;
import jhi.flapjack.gui.pedver.PedVerF1sPanelNB;
import jhi.flapjack.gui.pedver.PedVerF1sTableModel;
import jhi.flapjack.gui.table.ITableViewListener;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LinkedTableHandler;

public class PedVerF1sPanel
extends JPanel
implements ActionListener,
ITableViewListener,
TableModelListener {
    private LineDataTable table;
    private PedVerF1sTableModel model;
    private LinkedTableHandler tableHandler;
    private PedVerF1sPanelNB controls = new PedVerF1sPanelNB(this);

    public PedVerF1sPanel(GTViewSet viewSet) {
        this.table = (LineDataTable)this.controls.table;
        this.table.addViewListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new TitlePanel("Pedigree Verification of F1s (Known Parents)"), "North");
        this.add(this.controls);
        this.updateModel(viewSet);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PedVerF1sPanel.this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PedVerF1sPanel.this.handlePopup(e);
            }
        });
        this.tableHandler = viewSet.tableHandler();
        this.tableHandler.linkTable(this.table, this.model);
        this.controls.autoResize.setSelected(this.tableHandler.isAutoResize());
    }

    public void updateModel(GTViewSet viewSet) {
        this.model = new PedVerF1sTableModel(viewSet);
        this.model.addTableModelListener(this);
        this.table.setModel(this.model);
        this.table.setViewSet(viewSet);
        this.tableFiltered();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.controls.bSort) {
            this.table.sortDialog();
        } else if (e.getSource() == this.controls.bExport) {
            this.table.exportData();
        } else if (e.getSource() == this.controls.autoResize) {
            this.table.autoResize(this.controls.autoResize.isSelected(), false);
        }
    }

    private void handlePopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        JPopupMenu menu = this.table.getMenu().createPopupMenu();
        menu.add((Component)new JPopupMenu.Separator(), 1);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void tablePreSorted() {
    }

    @Override
    public void tableSorted() {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.tableFiltered();
    }

    @Override
    public void tableFiltered() {
        this.controls.filterLabel.setText(this.table.getLineStatusText());
    }
}

