/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.navpanel;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.WinMainMenuBar;
import jhi.flapjack.gui.navpanel.BaseNode;
import jhi.flapjack.gui.navpanel.BookmarkNode;
import jhi.flapjack.gui.navpanel.DataSetNode;
import jhi.flapjack.gui.navpanel.VisualizationChildNode;
import jhi.flapjack.gui.navpanel.VisualizationNode;

public class NavPanelMenu
extends MouseInputAdapter {
    private JTree tree;
    private JPopupMenu menu = new JPopupMenu();
    private int menuShortcut;
    private JMenuItem dataRenameDataSet;
    private JMenuItem dataDeleteDataSet;
    private JMenuItem viewNewView;
    private JMenuItem viewRenameView;
    private JMenuItem viewDeleteView;
    private JMenuItem viewDeleteBookmark;

    public NavPanelMenu(JTree tree) {
        this.tree = tree;
        this.menuShortcut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.createItems();
    }

    private void createItems() {
        this.dataRenameDataSet = WinMainMenuBar.getItem(Actions.dataRenameDataSet, "gui.Actions.dataRenameDataSet", 0, 0);
        this.dataDeleteDataSet = WinMainMenuBar.getItem(Actions.dataDeleteDataSet, "gui.Actions.dataDeleteDataSet", 0, 0);
        this.viewNewView = WinMainMenuBar.getItem(Actions.viewNewView, "gui.Actions.viewNewView", 0, 0);
        this.viewRenameView = WinMainMenuBar.getItem(Actions.viewRenameView, "gui.Actions.viewRenameView", 0, 0);
        this.viewDeleteView = WinMainMenuBar.getItem(Actions.viewDeleteView, "gui.Actions.viewDeleteView", 0, 0);
        this.viewDeleteBookmark = WinMainMenuBar.getItem(Actions.viewDeleteBookmark, "gui.Actions.viewDeleteBookmark", 0, 0);
    }

    void handlePopup(MouseEvent e) {
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        this.tree.setSelectionPath(path);
        BaseNode node = (BaseNode)this.tree.getLastSelectedPathComponent();
        this.menu = new JPopupMenu();
        if (node instanceof DataSetNode) {
            this.menu.add(this.dataRenameDataSet);
            this.menu.add(this.dataDeleteDataSet);
            this.menu.addSeparator();
            this.menu.add(this.viewNewView);
        } else if (node instanceof VisualizationNode) {
            this.menu.add(this.viewNewView);
            this.menu.add(this.viewRenameView);
            this.menu.add(this.viewDeleteView);
        } else if (node instanceof VisualizationChildNode && !(node instanceof BookmarkNode)) {
            this.menu.add(this.viewRenameView);
        } else if (node instanceof BookmarkNode) {
            this.menu.add(this.viewDeleteBookmark);
        } else {
            return;
        }
        this.menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        }
    }
}

