/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.security.Principal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Application;
import org.restlet.engine.util.SystemUtils;

public class Role
implements Principal {
    @Deprecated
    public static final Role ALL = new Role("*", "Role that covers all existing roles."){

        @Override
        public void setApplication(Application application) {
            throw new IllegalStateException("Unmodifiable role");
        }

        @Override
        public void setDescription(String description) {
            throw new IllegalStateException("Unmodifiable role");
        }

        @Override
        public void setName(String name) {
            throw new IllegalStateException("Unmodifiable role");
        }
    };
    private volatile Application application;
    private final List<Role> childRoles;
    private volatile String description;
    private volatile String name;

    public static Role get(Application application, String name) {
        return Role.get(application, name, null);
    }

    public static Role get(Application application, String name, String description) {
        Role role = application == null ? null : application.getRole(name);
        return role == null ? new Role(application, name, description) : role;
    }

    public Role() {
        this(Application.getCurrent(), null, null);
    }

    public Role(Application application, String name) {
        this(application, name, null);
    }

    public Role(Application application, String name, String description) {
        this.application = application;
        this.name = name;
        this.description = description;
        this.childRoles = new CopyOnWriteArrayList<Role>();
    }

    @Deprecated
    public Role(String name) {
        this(Application.getCurrent(), name, null);
    }

    @Deprecated
    public Role(String name, String description) {
        this(Application.getCurrent(), name, description);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Role)) {
            return false;
        }
        Role role = (Role)o;
        return SystemUtils.equals(role.getApplication(), this.getApplication()) && SystemUtils.equals(role.getName(), this.getName()) && SystemUtils.equals(role.getChildRoles(), this.getChildRoles());
    }

    public Application getApplication() {
        return this.application;
    }

    public List<Role> getChildRoles() {
        return this.childRoles;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(this.getApplication(), this.getName(), this.getChildRoles());
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildRoles(List<Role> childRoles) {
        List<Role> list = this.getChildRoles();
        synchronized (list) {
            if (childRoles != this.getChildRoles()) {
                this.getChildRoles().clear();
                if (childRoles != null) {
                    this.getChildRoles().addAll(childRoles);
                }
            }
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

