/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.brapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import jhi.brapi.api.BrapiBaseResource;
import jhi.brapi.api.BrapiListResource;
import jhi.brapi.api.Status;
import jhi.brapi.api.allelematrices.BrapiAlleleMatrixDataset;
import jhi.brapi.api.authentication.BrapiSessionToken;
import jhi.brapi.api.authentication.BrapiTokenLoginPost;
import jhi.brapi.api.calls.BrapiCall;
import jhi.brapi.api.genomemaps.BrapiGenomeMap;
import jhi.brapi.api.genomemaps.BrapiMapMetaData;
import jhi.brapi.api.genomemaps.BrapiMarkerPosition;
import jhi.brapi.api.markerprofiles.BrapiAlleleMatrix;
import jhi.brapi.api.markerprofiles.BrapiAlleleMatrixSearchPost;
import jhi.brapi.api.markerprofiles.BrapiMarkerProfile;
import jhi.brapi.api.studies.BrapiStudies;
import jhi.brapi.api.studies.BrapiStudiesPost;
import jhi.brapi.client.AsyncChecker;
import jhi.brapi.client.ErrorHandler;
import jhi.brapi.client.Pager;
import jhi.brapi.client.RetrofitService;
import jhi.brapi.client.RetrofitServiceGenerator;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.brapi.CallsUtils;
import jhi.flapjack.io.brapi.XmlBrapiProvider;
import jhi.flapjack.io.brapi.XmlResource;
import retrofit2.Call;
import retrofit2.Response;

public class BrapiClient {
    private RetrofitServiceGenerator generator;
    private RetrofitService service;
    private String baseURL;
    private XmlResource resource;
    private String username;
    private String password;
    private String mapID;
    private String studyID;
    private String methodID;
    private String matrixID;
    private CallsUtils callsUtils;

    public void initService() {
        this.baseURL = this.resource.getUrl();
        this.baseURL = this.baseURL.endsWith("/") ? this.baseURL : this.baseURL + "/";
        this.generator = new RetrofitServiceGenerator(this.baseURL, this.resource.getCertificate());
        this.service = this.generator.generate(null);
    }

    private String enc(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public void getCalls() throws Exception {
        ArrayList<BrapiCall> calls = new ArrayList<BrapiCall>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            Response response = this.service.getCalls(null, pager.getPageSize(), pager.getPage()).execute();
            if (response.isSuccessful()) {
                BrapiListResource callResponse = (BrapiListResource)response.body();
                calls.addAll(callResponse.data());
                pager.paginate(callResponse.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        this.callsUtils = new CallsUtils(calls);
        if (!this.callsUtils.validate()) {
            throw new Exception("The selected BrAPI service does not appear to support the required functionality for use by Flapjack (" + this.callsUtils.exceptionMsg + ").");
        }
    }

    public boolean hasToken() {
        return this.callsUtils.hasToken();
    }

    public boolean hasAlleleMatrixSearchTSV() {
        return this.callsUtils.hasAlleleMatrixSearchTSV();
    }

    public boolean hasAlleleMatrixSearchFlapjack() {
        return this.callsUtils.hasAlleleMatrixSearchFlapjack();
    }

    public boolean hasMapsMapDbId() {
        return this.callsUtils.hasMapsMapDbId();
    }

    public boolean hasAlleleMatrices() {
        return this.callsUtils.hasAlleleMatrices();
    }

    public boolean hasStudiesSearchGET() {
        return this.callsUtils.hasStudiesSearchGET();
    }

    public boolean hasStudiesSearchPOST() {
        return this.callsUtils.hasStudiesSearchPOST();
    }

    public boolean doAuthentication() throws Exception {
        if (this.username == null && this.password == null) {
            return false;
        }
        BrapiTokenLoginPost tokenPost = new BrapiTokenLoginPost(this.enc(this.username), this.enc(this.password), "password", "flapjack");
        Response response = this.service.getAuthToken(tokenPost).execute();
        if (response.isSuccessful()) {
            BrapiSessionToken token = (BrapiSessionToken)response.body();
            if (token == null) {
                return false;
            }
            this.service = this.generator.generate(token.getAccess_token());
            return true;
        }
        String errorMessage = ErrorHandler.getMessage(this.generator, response);
        throw new Exception(errorMessage);
    }

    public List<BrapiGenomeMap> getMaps() throws Exception {
        ArrayList<BrapiGenomeMap> mapList = new ArrayList<BrapiGenomeMap>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            Response response = this.service.getMaps(null, null, pager.getPageSize(), pager.getPage()).execute();
            if (response.isSuccessful()) {
                BrapiListResource maps = (BrapiListResource)response.body();
                mapList.addAll(maps.data());
                pager.paginate(maps.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        return mapList;
    }

    public List<BrapiMarkerPosition> getMapMarkerData() throws Exception {
        ArrayList<BrapiMarkerPosition> mapDetailList = new ArrayList<BrapiMarkerPosition>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            Response response = this.service.getMapMarkerData(this.enc(this.mapID), null, pager.getPageSize(), pager.getPage()).execute();
            if (response.isSuccessful()) {
                BrapiListResource mapDetails = (BrapiListResource)response.body();
                mapDetailList.addAll(mapDetails.data());
                pager.paginate(mapDetails.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        return mapDetailList;
    }

    public BrapiMapMetaData getMapMetaData() throws Exception {
        Response response = this.service.getMapMetaData(this.enc(this.mapID)).execute();
        if (response.isSuccessful()) {
            BrapiBaseResource mapMetaData = (BrapiBaseResource)response.body();
            return (BrapiMapMetaData)mapMetaData.getResult();
        }
        String errorMessage = ErrorHandler.getMessage(this.generator, response);
        throw new Exception(errorMessage);
    }

    public List<BrapiStudies> getStudies() throws Exception {
        ArrayList<BrapiStudies> studiesList = new ArrayList<BrapiStudies>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            Response response = this.service.getStudies("genotype", pager.getPageSize(), pager.getPage()).execute();
            if (response.isSuccessful()) {
                BrapiListResource studies = (BrapiListResource)response.body();
                studiesList.addAll(studies.data());
                pager.paginate(studies.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        return studiesList;
    }

    public List<BrapiStudies> getStudiesByPost() throws Exception {
        ArrayList<BrapiStudies> studiesList = new ArrayList<BrapiStudies>();
        Pager pager = new Pager();
        BrapiStudiesPost post = new BrapiStudiesPost();
        post.setStudyType("genotype");
        while (pager.isPaging()) {
            Response response = this.service.getStudiesPost(post).execute();
            if (response.isSuccessful()) {
                BrapiListResource studies = (BrapiListResource)response.body();
                studiesList.addAll(studies.data());
                pager.paginate(studies.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        return studiesList;
    }

    public List<BrapiMarkerProfile> getMarkerProfiles() throws Exception {
        ArrayList<BrapiMarkerProfile> markerProfileList = new ArrayList<BrapiMarkerProfile>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            Response response = this.service.getMarkerProfiles(null, this.studyID, null, null, pager.getPageSize(), pager.getPage()).execute();
            if (response.isSuccessful()) {
                BrapiListResource markerProfiles = (BrapiListResource)response.body();
                markerProfileList.addAll(markerProfiles.data());
                pager.paginate(markerProfiles.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        return markerProfileList;
    }

    public List<BrapiAlleleMatrixDataset> getMatrices() throws Exception {
        ArrayList<BrapiAlleleMatrixDataset> alleleMatrixList = new ArrayList<BrapiAlleleMatrixDataset>();
        Pager pager = new Pager();
        while (pager.isPaging()) {
            Response response = this.service.getMatrices(this.studyID, pager.getPageSize(), pager.getPage()).execute();
            if (response.isSuccessful()) {
                BrapiListResource alleleMatrices = (BrapiListResource)response.body();
                alleleMatrixList.addAll(alleleMatrices.data());
                pager.paginate(alleleMatrices.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        return alleleMatrixList;
    }

    public List<BrapiAlleleMatrix> getAlleleMatrix(List<BrapiMarkerProfile> markerprofiles) throws Exception {
        ArrayList<BrapiAlleleMatrix> alleleMatrixList = new ArrayList<BrapiAlleleMatrix>();
        Pager pager = new Pager();
        List<String> ids = markerprofiles.stream().map(BrapiMarkerProfile::getMarkerprofileDbId).collect(Collectors.toList());
        while (pager.isPaging()) {
            Response response = this.service.getAlleleMatrix(ids, null, null, null, null, null, null, pager.getPageSize(), pager.getPage()).execute();
            if (response.isSuccessful()) {
                BrapiBaseResource alleleMatrix = (BrapiBaseResource)response.body();
                alleleMatrixList.add((BrapiAlleleMatrix)alleleMatrix.getResult());
                pager.paginate(alleleMatrix.getMetadata());
                continue;
            }
            String errorMessage = ErrorHandler.getMessage(this.generator, response);
            throw new Exception(errorMessage);
        }
        return alleleMatrixList;
    }

    public URI getAlleleMatrixFileByProfiles(List<BrapiMarkerProfile> markerProfiles, String format) throws Exception {
        List<String> ids = markerProfiles.stream().map(BrapiMarkerProfile::getMarkerprofileDbId).collect(Collectors.toList());
        BrapiAlleleMatrixSearchPost alleleMatrixSearchPost = new BrapiAlleleMatrixSearchPost();
        alleleMatrixSearchPost.setMarkerprofileDbId(ids);
        alleleMatrixSearchPost.setFormat(format);
        Response response = this.service.getAlleleMatrix(alleleMatrixSearchPost).execute();
        if (!response.isSuccessful()) {
            response = this.service.getAlleleMatrix(ids, null, format, null, null, null, null, null, null).execute();
        }
        return this.handleAlleleMatrixReponse((Response<BrapiBaseResource<BrapiAlleleMatrix>>)response);
    }

    public URI getAlleleMatrixFileById() throws Exception {
        Response response = this.service.getAlleleMatrix(this.matrixID, "flapjack", null, null, null, null, null, null).execute();
        return this.handleAlleleMatrixReponse((Response<BrapiBaseResource<BrapiAlleleMatrix>>)response);
    }

    private URI handleAlleleMatrixReponse(Response<BrapiBaseResource<BrapiAlleleMatrix>> response) throws Exception {
        if (response.isSuccessful()) {
            BrapiBaseResource alleleMatrix = (BrapiBaseResource)response.body();
            Status async = AsyncChecker.hasAsyncId(alleleMatrix.getMetadata().getStatus());
            if (async != null) {
                return this.pollAlleleMatrixStatus(async.getMessage());
            }
            if (alleleMatrix.getMetadata().getDatafiles().size() >= 1) {
                return new URI(alleleMatrix.getMetadata().getDatafiles().get(0));
            }
            throw new Exception("Resource indicated it wasn't asynchronous and also doesn't contain a datafile in the metadata object.");
        }
        String errorMessage = ErrorHandler.getMessage(this.generator, response);
        throw new Exception(errorMessage);
    }

    private URI pollAlleleMatrixStatus(String id) throws Exception {
        Call<BrapiListResource<Object>> statusCall = this.service.getAlleleMatrixStatus(id);
        BrapiListResource statusPoll = (BrapiListResource)statusCall.execute().body();
        AsyncChecker.AsyncStatus status = AsyncChecker.checkStatus(statusPoll.getMetadata().getStatus());
        while (status == AsyncChecker.AsyncStatus.PENDING || status == AsyncChecker.AsyncStatus.INPROCESS) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            statusPoll = (BrapiListResource)statusCall.clone().execute().body();
            status = AsyncChecker.checkStatus(statusPoll.getMetadata().getStatus());
        }
        if (status == AsyncChecker.AsyncStatus.FINISHED) {
            return new URI(statusPoll.getMetadata().getDatafiles().get(0));
        }
        if (status == AsyncChecker.AsyncStatus.FAILED) {
            throw new Exception("The BrAPI resource returned the following asynchronous status: " + status.toString());
        }
        if (status == AsyncChecker.AsyncStatus.UNKNOWN) {
            throw new Exception("Unknown asynchronous status returned by BrAPI resource.");
        }
        throw new Exception("The BrAPI resource has not returned an asynchronous status that can be understood by Flapjack.");
    }

    public XmlBrapiProvider getBrapiProviders() throws Exception {
        URL url = new URL("https://ics.hutton.ac.uk/resources/brapi/brapi.zip");
        File dir = new File(FlapjackUtils.getCacheDir(), "brapi");
        dir.mkdirs();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(url.openStream()));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int n;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(dir, ze.getName())));
            BufferedInputStream in = new BufferedInputStream(zis);
            byte[] b = new byte[4096];
            while ((n = in.read(b)) != -1) {
                out.write(b, 0, n);
            }
            out.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlBrapiProvider.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        File xml = new File(dir, "brapi.xml");
        return (XmlBrapiProvider)jaxbUnmarshaller.unmarshal(xml);
    }

    public boolean requiresAuthentication() throws Exception {
        Pager pager = new Pager();
        int responseCode = this.service.getStudies("genotype", pager.getPageSize(), pager.getPage()).execute().code();
        return responseCode == 401 || responseCode == 403;
    }

    InputStream getInputStream(URI uri) throws Exception {
        return this.generator.getInputStream(uri);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public void setMethodID(String methodID) {
        this.methodID = methodID;
    }

    public XmlResource getResource() {
        return this.resource;
    }

    public void setResource(XmlResource resource) {
        this.resource = resource;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void setMapID(String mapIndex) {
        this.mapID = mapIndex;
    }

    public String getStudyID() {
        return this.studyID;
    }

    public void setStudyID(String studyID) {
        this.studyID = studyID;
    }

    public String getMatrixID() {
        return this.matrixID;
    }

    public void setMatrixID(String matrixID) {
        this.matrixID = matrixID;
    }
}

