/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import jhi.flapjack.data.results.SimMatrix;
import scri.commons.gui.SimpleJob;

public class SimMatrixExporter
extends SimpleJob {
    private SimMatrix matrix;
    private PrintWriter writer;
    private boolean hasRowHeader;
    private String filename;
    private boolean isFileWriting;

    public SimMatrixExporter(SimMatrix matrix, PrintWriter writer) {
        this.matrix = matrix;
        this.writer = writer;
        this.maximum = matrix.getLineInfos().size() + 1;
        this.hasRowHeader = false;
    }

    public SimMatrixExporter(SimMatrix matrix, String filename) {
        this.matrix = matrix;
        this.filename = filename;
        this.maximum = matrix.getLineInfos().size() + 1;
        this.hasRowHeader = true;
        this.isFileWriting = true;
    }

    public void runJob(int i) throws Exception {
        String EOL = "\r\n";
        if (this.filename != null) {
            this.writer = new PrintWriter(new FileOutputStream(new File(this.filename)));
            EOL = System.getProperty("line.separator");
        }
        this.writer.print(this.matrix.createFileHeaderLine(this.hasRowHeader));
        this.writer.flush();
        this.writer.print(EOL);
        this.writer.flush();
        ++this.progress;
        int j = 0;
        while (j < this.matrix.getLineInfos().size() && this.okToRun) {
            this.writer.print(this.matrix.createFileLine(j, this.hasRowHeader));
            this.writer.flush();
            this.writer.print(EOL);
            this.writer.flush();
            ++j;
            ++this.progress;
        }
        if (this.isFileWriting) {
            this.writer.close();
        }
    }
}

