/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.table;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jhi.flapjack.analysis.SortLinesByLineDataModel;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.table.CellData;
import jhi.flapjack.gui.table.ExportDialog;
import jhi.flapjack.gui.table.FilterColumn;
import jhi.flapjack.gui.table.FilterDialog;
import jhi.flapjack.gui.table.ITableViewListener;
import jhi.flapjack.gui.table.LineDataTableExporter;
import jhi.flapjack.gui.table.LineDataTableMenu;
import jhi.flapjack.gui.table.LineDataTableModel;
import jhi.flapjack.gui.table.SortColumn;
import jhi.flapjack.gui.table.SortDialog;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.undo.HidLinesState;
import jhi.flapjack.gui.visualization.undo.SelectedLinesState;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class LineDataTable
extends JTable {
    private GTViewSet viewSet;
    private LinkedList<ITableViewListener> viewListeners = new LinkedList();
    private LineDataTableModel model;
    private TableRowSorter<LineDataTableModel> sorter;
    private LineDataTableMenu menu;
    private CellData.DefaultRenderer renderer = new CellData.DefaultRenderer();
    private SortColumn[] lastSort;
    private FilterColumn[] dialogFilter;
    private FilterColumn[] tableFilter;
    private FilterColumn[] lastSelect;
    private boolean colorCells = true;

    public LineDataTable() {
        this.setDefaultRenderer(CellData.class, this.renderer);
        this.menu = new LineDataTableMenu(this);
        this.tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LineDataTable.this.viewListeners.forEach(ITableViewListener::tablePreSorted);
            }
        });
    }

    FilterColumn[] getDialogFilter() {
        return this.dialogFilter;
    }

    void setDialogFilter(FilterColumn[] dialogFilter) {
        this.dialogFilter = dialogFilter;
    }

    public FilterColumn[] getTableFilter() {
        return this.tableFilter;
    }

    public void setTableFilter(FilterColumn[] tableFilter) {
        this.tableFilter = tableFilter;
    }

    FilterColumn[] getLastSelect() {
        return this.lastSelect;
    }

    void setLastSelect(FilterColumn[] lastSelect) {
        this.lastSelect = lastSelect;
    }

    SortColumn[] getLastSort() {
        return this.lastSort;
    }

    void setLastSort(SortColumn[] lastSort) {
        this.lastSort = lastSort;
    }

    public LineDataTableMenu getMenu() {
        return this.menu;
    }

    LineDataTableModel getLineDataTableModel() {
        return this.model;
    }

    public void addViewListener(ITableViewListener listener) {
        this.viewListeners.add(listener);
    }

    public void setColorCells(boolean colorCells) {
        this.colorCells = colorCells;
        this.renderer.setColorCells(this.colorCells);
    }

    TableRowSorter<LineDataTableModel> sorter() {
        return this.sorter;
    }

    @Override
    public JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                if (index >= 0 && index < this.columnModel.getColumnCount()) {
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    String tt = LineDataTable.this.getModel().getColumnName(realIndex);
                    return ((LineDataTableModel)LineDataTable.this.getModel()).getToolTip(realIndex);
                }
                return null;
            }
        };
    }

    @Override
    public void setModel(TableModel tm) {
        boolean firstInit = this.getModel() == null;
        super.setModel(tm);
        if (firstInit) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(120);
            }
        }
        if (tm instanceof LineDataTableModel) {
            this.model = (LineDataTableModel)tm;
            this.sorter = new TableRowSorter<LineDataTableModel>(this.model);
            this.setRowSorter(this.sorter);
            CellData.CellDataComparator c = new CellData.CellDataComparator(this.sorter);
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                this.sorter.setComparator(i, c);
            }
            this.sorter.addRowSorterListener(e -> {
                if (e.getType() == RowSorterEvent.Type.SORTED) {
                    for (ITableViewListener listener : this.viewListeners) {
                        listener.tableSorted();
                    }
                }
            });
            this.sorter.setRowFilter(RowFilter.andFilter(this.createBaseFilters()));
        }
    }

    public void setViewSet(GTViewSet viewSet) {
        this.viewSet = viewSet;
    }

    public void autoResize(boolean autoResize, boolean isLoading) {
        if (autoResize) {
            this.setAutoResizeMode(4);
        } else {
            this.setAutoResizeMode(0);
        }
        if (this.viewSet != null) {
            this.viewSet.tableHandler().setAutoResize(autoResize);
        }
        if (!isLoading) {
            Actions.projectModified();
        }
    }

    public void exportData() {
        boolean exportHeaders;
        int exportType;
        ExportDialog dialog = new ExportDialog();
        if (!dialog.isOK()) {
            return;
        }
        File filename = dialog.getFilename();
        LineDataTableExporter exporter = new LineDataTableExporter(this, filename, exportType = Prefs.guiLDTableExportType, exportHeaders = Prefs.guiLDTableExportHeaders);
        ProgressDialog pDialog = new ProgressDialog((ITrackableJob)exporter, RB.format((String)"gui.dialog.ExportDataDialog.exportTitle", (Object[])new Object[0]), RB.format((String)"gui.dialog.ExportDataDialog.exportLabel", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (pDialog.failed("gui.error")) {
            return;
        }
        TaskDialog.info((String)RB.format((String)"gui.dialog.ExportDataDialog.exportSuccess", (Object[])new Object[]{filename}), (String)RB.getString((String)"gui.text.close"));
    }

    public void copyTableToClipboard() {
        StringBuilder text = new StringBuilder();
        String newline = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat("#.#########");
        for (int c = 0; c < this.getColumnCount(); ++c) {
            text.append(this.model.getColumnName(this.convertColumnIndexToModel(c)));
            text.append(c < this.getColumnCount() - 1 ? "\t" : newline);
        }
        for (int r = 0; r < this.getRowCount(); ++r) {
            int row = this.convertRowIndexToModel(r);
            for (int c = 0; c < this.getColumnCount(); ++c) {
                int mCol = this.convertColumnIndexToModel(c);
                Object obj = this.model.getValueAt(row, mCol);
                if (obj instanceof Float || obj instanceof Double) {
                    text.append(df.format(obj));
                } else {
                    text.append(obj);
                }
                text.append(c < this.getColumnCount() - 1 ? "\t" : newline);
            }
        }
        StringSelection selection = new StringSelection(text.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
    }

    public void sortDialog() {
        SortDialog dialog = new SortDialog(this.model.getSortableColumns(), this.lastSort);
        if (!dialog.isOK()) {
            return;
        }
        SortColumn[] data = dialog.getResults();
        this.lastSort = dialog.getResults();
        SortLinesByLineDataModel s = new SortLinesByLineDataModel(this.viewSet, this.sorter, data);
        Flapjack.winMain.mAnalysis.runSort((ITrackableJob)s, this.viewSet);
        this.model.fireTableDataChanged();
    }

    private ArrayList<RowFilter<LineDataTableModel, Object>> createBaseFilters() {
        ArrayList<RowFilter<LineDataTableModel, Object>> filters = new ArrayList<RowFilter<LineDataTableModel, Object>>();
        filters.add(new RowFilter<LineDataTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends LineDataTableModel, ? extends Object> entry) {
                CellData cell = (CellData)entry.getValue(0);
                LineInfo line = cell.getLineInfo();
                return line == null || line.getVisibility() != LineInfo.HIDDEN;
            }
        });
        return filters;
    }

    public void filterDialog() {
        FilterDialog dialog = FilterDialog.getFilterDialog(this.model.getFilterableColumns(), this.dialogFilter);
        if (!dialog.isOK()) {
            return;
        }
        HidLinesState state = new HidLinesState(this.viewSet, "table filtered");
        state.createUndoState();
        this.dialogFilter = dialog.getResults();
        this.tableFilter = dialog.getResults();
        this.filter();
        state.createRedoState();
        Flapjack.winMain.getGenotypePanel().addUndoState(state);
    }

    void filter() {
        ArrayList<RowFilter<LineDataTableModel, Object>> filters = this.createBaseFilters();
        if (this.tableFilter != null) {
            for (FilterColumn entry : this.tableFilter) {
                if (entry.disabled()) continue;
                filters.add(entry.createRowFilter());
            }
        }
        RowFilter<LineDataTableModel, Object> f = RowFilter.andFilter(filters);
        this.sorter.setRowFilter(f);
        for (ITableViewListener listener : this.viewListeners) {
            listener.tableFiltered();
        }
    }

    void resetFilters() {
        HidLinesState state = new HidLinesState(this.viewSet, "reset table filters");
        state.createUndoState();
        this.model.clearAllFilters();
        this.tableFilter = null;
        this.filter();
        state.createRedoState();
        Flapjack.winMain.getGenotypePanel().addUndoState(state);
    }

    public void selectDialog() {
        FilterDialog dialog = FilterDialog.getSelectDialog(this.model.getFilterableColumns(), this.lastSelect);
        if (!dialog.isOK()) {
            return;
        }
        GenotypePanel gPanel = Flapjack.winMain.getGenotypePanel();
        SelectedLinesState undo = new SelectedLinesState(gPanel.getView(), "selected lines");
        undo.createUndoState();
        FilterColumn[] data = dialog.getResults();
        this.lastSelect = dialog.getResults();
        this.model.selectLines(data, true);
        undo.createRedoState();
        gPanel.addUndoState(undo);
        Flapjack.winMain.mEdit.editMode(2);
    }

    void selectHighlighted(Boolean state) {
        GenotypePanel gPanel = Flapjack.winMain.getGenotypePanel();
        SelectedLinesState undo = new SelectedLinesState(gPanel.getView(), "selected lines");
        undo.createUndoState();
        ListSelectionModel lsModel = this.getSelectionModel();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!lsModel.isSelectedIndex(i)) continue;
            LineInfo line = this.model.getLines().get(this.convertRowIndexToModel(i));
            if (state != null) {
                line.setSelected(state);
                continue;
            }
            line.setSelected(!line.getSelected());
        }
        this.model.fireTableRowsUpdated(0, this.model.getRowCount() - 1);
        Actions.projectModified();
        undo.createRedoState();
        gPanel.addUndoState(undo);
        Flapjack.winMain.mEdit.editMode(2);
    }

    public int rankSelectedLines(int rank, int rankColumn) {
        SpinnerNumberModel sModel = new SpinnerNumberModel(rank, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        JSpinner spinner = new JSpinner(sModel);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(4);
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(new JLabel(RB.getString((String)"gui.mabc.MabcPanel.rankLabel")));
        panel.add(spinner);
        int option = JOptionPane.showOptionDialog(Flapjack.winMain, panel, RB.getString((String)"gui.mabc.MabcPanel.rankTitle"), 2, 3, null, null, null);
        if (option == 0) {
            rank = (Integer)spinner.getValue();
            ListSelectionModel lsModel = this.getSelectionModel();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!lsModel.isSelectedIndex(i)) continue;
                this.setValueAt(rank, i, rankColumn);
            }
            this.model.fireTableRowsUpdated(0, this.model.getRowCount() - 1);
        }
        return rank;
    }

    public String getLineStatusText() {
        return "Line count: " + this.model.getRowCount() + ", visible: " + this.getRowCount() + ", selected: " + this.model.visAndSelCount();
    }

    public Object getObjectAt(int row, int col) {
        return ((CellData)this.getValueAt(row, col)).getData();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        final int modelRow = this.convertRowIndexToModel(row);
        final int modelCol = this.convertColumnIndexToModel(col);
        if (this.model.getObjectColumnClass(modelCol) == Boolean.class) {
            JCheckBox checkBox = new JCheckBox();
            checkBox.setHorizontalAlignment(0);
            return new DefaultCellEditor(checkBox){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    boolean b = (Boolean)LineDataTable.this.model.getObjectAt(modelRow, modelCol);
                    return super.getTableCellEditorComponent(table, b, isSelected, row, column);
                }
            };
        }
        if (this.model.getObjectColumnClass(modelCol) == String.class) {
            return new DefaultCellEditor(new JTextField());
        }
        return super.getCellEditor(row, col);
    }

    public boolean skipExport(int col) {
        int modelCol = this.convertColumnIndexToModel(col);
        return this.model.skipExport(modelCol);
    }
}

