/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.GenotypeData;

public class SimilarityScore {
    private GTViewSet viewSet;
    private float[][] matrix;
    private int compLine;
    private int currLine;
    private boolean[] chromosomes;

    public SimilarityScore(GTViewSet viewSet, float[][] matrix, boolean[] chromosomes) {
        this.viewSet = viewSet;
        this.matrix = matrix;
        this.chromosomes = chromosomes;
    }

    public Score getScore(int compLine, int currLine) {
        float nComparisons = 0.0f;
        float score = 0.0f;
        StringBuilder data = new StringBuilder();
        for (int viewIndex = 0; viewIndex < this.viewSet.chromosomeCount(); ++viewIndex) {
            if (!this.chromosomes[viewIndex]) continue;
            GTView view = this.viewSet.getView(viewIndex);
            int markerCount = view.markerCount();
            for (int marker = 0; marker < markerCount; ++marker) {
                if (!view.isMarkerSelected(marker)) continue;
                int state1 = view.getState(compLine, marker);
                int state2 = view.getState(currLine, marker);
                if (state1 == 0 || state2 == 0) continue;
                score += this.matrix[state1][state2];
                nComparisons += 1.0f;
                data.append(state2);
            }
        }
        score = nComparisons > 0.0f ? (score /= nComparisons) : 0.0f;
        return new Score(score, nComparisons, data.toString());
    }

    public float getScore(ArrayList<GenotypeData> currLineData, ArrayList<GenotypeData> compLineData, ArrayList<int[]> mkrData) {
        float nComparisons = 0.0f;
        float score = 0.0f;
        for (int i = 0; i < currLineData.size(); ++i) {
            GenotypeData currLine = currLineData.get(i);
            GenotypeData compLine = compLineData.get(i);
            int[] markers = mkrData.get(i);
            for (int j = 0; j < markers.length; ++j) {
                int state1 = currLine.getState(markers[j]);
                int state2 = compLine.getState(markers[j]);
                if (state1 == 0 || state2 == 0) continue;
                score += this.matrix[state1][state2];
                nComparisons += 1.0f;
            }
        }
        score = nComparisons > 0.0f ? (score /= nComparisons) : 0.0f;
        return score;
    }

    static class Score {
        float score;
        float nComparisons;
        String data;

        Score(float score, float nComparisons, String data) {
            this.score = score;
            this.nComparisons = nComparisons;
            this.data = data;
        }
    }
}

