/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.pedver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.TitlePanel;
import jhi.flapjack.gui.pedver.PedVerLinesPanelNB;
import jhi.flapjack.gui.pedver.PedVerLinesTableModel;
import jhi.flapjack.gui.table.ITableViewListener;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LinkedTableHandler;
import scri.commons.gui.RB;

public class PedVerLinesPanel
extends JPanel
implements ActionListener,
ITableViewListener,
TableModelListener {
    private LineDataTable table;
    private PedVerLinesTableModel model;
    private LinkedTableHandler tableHandler;
    private PedVerLinesPanelNB controls = new PedVerLinesPanelNB(this);

    public PedVerLinesPanel(GTViewSet viewSet) {
        this.table = (LineDataTable)this.controls.table;
        this.table.addViewListener(this);
        LineInfo line = viewSet.getLines().get(0);
        this.setLayout(new BorderLayout());
        this.add((Component)new TitlePanel(RB.getString((String)"gui.pedver.PedVerLinesPanel.title")), "North");
        this.add(this.controls);
        this.updateModel(viewSet.getDataSet(), viewSet);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PedVerLinesPanel.this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PedVerLinesPanel.this.handlePopup(e);
            }
        });
        this.tableHandler = viewSet.tableHandler();
        this.tableHandler.linkTable(this.table, this.model);
        this.controls.autoResize.setSelected(this.tableHandler.isAutoResize());
    }

    public void updateModel(DataSet dataSet, GTViewSet viewSet) {
        this.model = new PedVerLinesTableModel(dataSet, viewSet);
        this.model.addTableModelListener(this);
        this.table.setModel(this.model);
        this.table.setViewSet(viewSet);
        this.tableFiltered();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.controls.bSort) {
            this.table.sortDialog();
        } else if (e.getSource() == this.controls.bExport) {
            this.table.exportData();
        } else if (e.getSource() == this.controls.autoResize) {
            this.table.autoResize(this.controls.autoResize.isSelected(), false);
        }
    }

    private void handlePopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        JPopupMenu menu = this.table.getMenu().createPopupMenu();
        menu.add((Component)new JPopupMenu.Separator(), 1);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void tablePreSorted() {
    }

    @Override
    public void tableSorted() {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.tableFiltered();
    }

    @Override
    public void tableFiltered() {
        this.controls.filterLabel.setText(this.table.getLineStatusText());
    }
}

