import sys

from ij import IJ

# Fiji Jython interpreter implements Python 2.5 which does not
# provide support for argparse.
input = sys.argv[-6]
equalize_histogram = sys.argv[-5] == "yes"
saturated_pixels = sys.argv[-4]
normalize = sys.argv[-3] == "yes"
tmp_output_path = sys.argv[-2]
output_datatype = sys.argv[-1]

# Open the input image file.
input_image_plus = IJ.openImage(input)

# Create a copy of the image.
input_image_plus_copy = input_image_plus.duplicate()
image_processor_copy = input_image_plus_copy.getProcessor()
bit_depth = image_processor_copy.getBitDepth()

# Set the options
options = []
# If equalize_histogram, saturated_pixels and normalize are ignored.
if equalize_histogram:
    options.append("equalize")
else:
    if saturated_pixels not in [None, "None"]:
        # Fiji allows only a single decimal place for this value.
        options.append("saturated=%.3f" % float(saturated_pixels))
    # Normalization of RGB images is not supported.
    if bit_depth != 24 and normalize:
        options.append("normalize")
# Run the command.
options = "%s" % " ".join(options)
IJ.run(input_image_plus_copy, "Enhance Contrast...", options)
# Save the ImagePlus object as a new image.
IJ.saveAs(input_image_plus_copy, output_datatype, tmp_output_path)
