# ChatGPT Galaxy tool

## What it does

This tool leverages OpenAI's ChatGPT API to generate responses based on user-provided context and prompt.
Users can upload context data in various formats and ask questions or execute prompts related to that data.
The tool then uploads the data to a OpenAI server and processes them using the selected ChatGPT model, returning an AI-generated response tailored to the context provided.

To utilize this tool, users need to input their OpenAI API key in the credentials section. To obtain an API key, visit https://platform.openai.com/account/api-keys.

Make sure to setup the payment method in your OpenAI account to use the API key in here: https://platform.openai.com/settings/organization/billing/

When you run this tool, your input data is sent to OpenAI's servers using your API-key. 
OpenAI's models process the data and generate a response based on the context and prompt provided. 
After receiving the response from the OpenAI server, the tool returns it to Galaxy and puts it in your history. 
The files that have been uploaded are then deleted from the OpenAI's server, so they are not stored beyond their necessary use. 
If the tool fails to delete your uploaded files automatically, you can manually delete them by visiting https://platform.openai.com/storage/. You might want to check your OpenAI storage from time to time as they also have a quota.

## Usage

**Input**

1. **Upload Context Data**: Users can upload up to 500 files in formats such as DOC, DOCX, HTML, JSON, PDF, TXT, JPG, JPEG, PNG, WEBP, or GIF. 
This context data serves as the input for the prompt you wish to execute.

2. **Provide a Prompt**: Once the context data is added, users can provide a prompt for a task ChatGPT should execute.
The more specific the prompt, the more tailored the response will be.

    [General thoughts on prompting with GPT-4](https://help.openai.com/en/articles/4936848-how-do-i-create-a-good-prompt-for-an-ai-model-like-gpt-4)

    [Open Ai's prompt example page for more information](https://platform.openai.com/docs/examples)

3. **Select a Model**: Choose the ChatGPT model that best fits your needs. 
Information about different models and their pricing can be found at https://platform.openai.com/docs/models and https://openai.com/api/pricing.


**Output**

The output is a response generated by ChatGPT, crafted based on the provided context data and the prompt posed.
This response is saved in the `output.txt` file.

