#!/bin/bash

## simple bash to generate mummerplot of MATCH file
##
## Galaxy wrapper by Alex Bossers, CVI of Wageningen UR, Lelystad, NL
## alex_dot_bossers_at_wur_dot_nl
##
##
## needs a rename of the fixed name to something recognised by galaxy
## needs cleanout of temp files
##
## call is mummerplot $format  $in_match $out_file $cmd_extra
##             $0        $1         $2       $3       $4
##
## since mummerplot uses some deprecated syntax which can be fixed in the source
## we redirect STDERR to dev/null to circumvent errorstatus in galaxy
## io redirects 0=stdin 1=stdout 2=stderr to dev/null (or &-)

# Function to send error messages.
log_err() { echo "$@" 1>&2; }

# path to where mummer suite is installed
# adjust this for your machine
# this is the only hard coded path in the scripts
mum_path=""

if [ $num_path"$(which mummer)" == "" ] && [ "$num_path" == "" ]; then
	log_err "mummer is not available in system path and not declarated in mum_path. Please install mummer."
	exit 127 
fi

# some default options to generate a LARGE fixed PNG/POSTSCRIPT image and not an interactive one.

if [ "$1" = "png" ]; then
	extension="png"
else
	extension="ps"
fi

eval "$mum_path mummerplot --large --$1 $2 1>&- 2>&-"
if [ -f "out.$extension" ]; then
	#conditional move to something known by galaxy
	mv out.$extension $3
	#remove gnuplot file
	rm out.gp
fi

## clean up
rm out.fplot
rm out.rplot

#end script
